/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.asyncprofiler.storage;

import com.google.gson.Gson;
import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.profiling.asyncprofiler.storage.JFRProfilingDataRecord;
import org.apache.skywalking.oap.server.core.source.JFRProfilingData;

public class JFRProfilingDataDispatcher
implements SourceDispatcher<JFRProfilingData> {
    private static final Gson GSON = new Gson();

    @Override
    public void dispatch(JFRProfilingData source) {
        JFRProfilingDataRecord record = new JFRProfilingDataRecord();
        record.setTaskId(source.getTaskId());
        record.setInstanceId(source.getInstanceId());
        record.setEventType(source.getEventType().toString());
        record.setDataBinary(GSON.toJson((Object)source.getFrameTree()).getBytes());
        record.setUploadTime(source.getUploadTime());
        record.setTimeBucket(TimeBucket.getRecordTimeBucket(source.getUploadTime()));
        RecordStreamProcessor.getInstance().in(record);
    }
}

