/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.io.IOException;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.query.PaginationUtils;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.Alarms;
import org.apache.skywalking.oap.server.core.query.type.Pagination;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;

public class AlarmQueryService
implements Service {
    private final ModuleManager moduleManager;
    private IAlarmQueryDAO alarmQueryDAO;

    public AlarmQueryService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private IAlarmQueryDAO getAlarmQueryDAO() {
        if (this.alarmQueryDAO == null) {
            this.alarmQueryDAO = (IAlarmQueryDAO)this.moduleManager.find("storage").provider().getService(IAlarmQueryDAO.class);
        }
        return this.alarmQueryDAO;
    }

    public Alarms getAlarm(Integer scopeId, String keyword, Pagination paging, Duration duration, List<Tag> tags) throws IOException {
        PaginationUtils.Page page = PaginationUtils.INSTANCE.exchange(paging);
        return this.getAlarmQueryDAO().getAlarm(scopeId, keyword, page.getLimit(), page.getFrom(), duration, tags);
    }
}

