/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class StorageID {
    private final List<Fragment> fragments = new ArrayList<Fragment>(2);
    private boolean sealed = false;
    private String builtID;

    public StorageID append(String value) {
        if (this.sealed) {
            throw new IllegalStateException("The storage ID is sealed. Can't append a new fragment");
        }
        this.fragments.add(new Fragment(null, String.class, value));
        return this;
    }

    public StorageID append(long value) {
        if (this.sealed) {
            throw new IllegalStateException("The storage ID is sealed. Can't append a new fragment, name=");
        }
        this.fragments.add(new Fragment(null, Long.class, value));
        return this;
    }

    public StorageID append(String name, String value) {
        if (StringUtil.isBlank((String)name)) {
            throw new IllegalArgumentException("The name of storage ID should not be null or empty.");
        }
        if (this.sealed) {
            throw new IllegalStateException("The storage ID is sealed. Can't append a new fragment, name=" + name);
        }
        this.fragments.add(new Fragment(name, String.class, value));
        return this;
    }

    public StorageID append(String name, long value) {
        if (StringUtil.isBlank((String)name)) {
            throw new IllegalArgumentException("The name of storage ID should not be null or empty.");
        }
        if (this.sealed) {
            throw new IllegalStateException("The storage ID is sealed. Can't append a new fragment, name=" + name);
        }
        this.fragments.add(new Fragment(name, Long.class, value));
        return this;
    }

    public StorageID append(String name, int value) {
        if (StringUtil.isBlank((String)name)) {
            throw new IllegalArgumentException("The name of storage ID should not be null or empty.");
        }
        if (this.sealed) {
            throw new IllegalStateException("The storage ID is sealed. Can't append a new fragment, name=" + name);
        }
        this.fragments.add(new Fragment(name, Integer.class, value));
        return this;
    }

    public String build() {
        this.sealed = true;
        if (this.builtID == null) {
            this.builtID = Joiner.on((String)"_").join(this.fragments);
        }
        return this.builtID;
    }

    public List<Fragment> read() {
        this.sealed = true;
        return Collections.unmodifiableList(this.fragments);
    }

    public String toString() {
        return this.build();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StorageID)) {
            return false;
        }
        StorageID other = (StorageID)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Fragment> this$fragments = this.fragments;
        List<Fragment> other$fragments = other.fragments;
        return !(this$fragments == null ? other$fragments != null : !((Object)this$fragments).equals(other$fragments));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StorageID;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Fragment> $fragments = this.fragments;
        result = result * 59 + ($fragments == null ? 43 : ((Object)$fragments).hashCode());
        return result;
    }

    public static class Fragment {
        private final String name;
        private final Class<?> type;
        private final Object value;

        public Optional<String> getName() {
            return Optional.ofNullable(this.name);
        }

        public String toString() {
            return this.value.toString();
        }

        @Generated
        public Fragment(String name, Class<?> type, Object value) {
            this.name = name;
            this.type = type;
            this.value = value;
        }

        @Generated
        public Class<?> getType() {
            return this.type;
        }

        @Generated
        public Object getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Fragment)) {
                return false;
            }
            Fragment other = (Fragment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.name;
            String other$name = other.name;
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Object this$value = this.value;
            Object other$value = other.value;
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Fragment;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.name;
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Object $value = this.value;
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }
}

