/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.worker;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.meter.function.AcceptableValue;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricStreamKind;
import org.apache.skywalking.oap.server.core.remote.data.StreamData;
import org.apache.skywalking.oap.server.core.worker.AbstractWorker;

public class RemoteHandleWorker {
    private final AbstractWorker worker;
    private final MetricStreamKind kind;
    private final Class<? extends StreamData> streamDataClass;
    private AcceptableValue<?> meterClassPrototype;

    public RemoteHandleWorker(AbstractWorker worker, MetricStreamKind kind, Class<? extends StreamData> streamDataClass) {
        this.worker = worker;
        this.kind = kind;
        this.streamDataClass = streamDataClass;
        if (MetricStreamKind.MAL == kind) {
            try {
                this.meterClassPrototype = (AcceptableValue)((Object)streamDataClass.newInstance());
            }
            catch (Exception e) {
                throw new UnexpectedException("Can't create mal meter prototype with stream class" + String.valueOf(streamDataClass));
            }
        }
    }

    public StreamData newStreamDataInstance() throws InstantiationException, IllegalAccessException {
        switch (this.kind) {
            case OAL: {
                return this.streamDataClass.newInstance();
            }
            case MAL: {
                return (StreamData)((Object)this.meterClassPrototype.createNew());
            }
        }
        throw new UnexpectedException("Unsupported metrics stream kind" + String.valueOf((Object)this.kind));
    }

    @Generated
    public AbstractWorker getWorker() {
        return this.worker;
    }

    @Generated
    public MetricStreamKind getKind() {
        return this.kind;
    }

    @Generated
    public Class<? extends StreamData> getStreamDataClass() {
        return this.streamDataClass;
    }

    @Generated
    public AcceptableValue<?> getMeterClassPrototype() {
        return this.meterClassPrototype;
    }
}

