/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als.k8s;

import io.envoyproxy.envoy.config.core.v3.Address;
import java.util.Objects;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class Addresses {
    public static boolean isValid(Address address) {
        if (Objects.isNull(address)) {
            return false;
        }
        if (address.hasSocketAddress()) {
            return StringUtil.isNotBlank((String)address.getSocketAddress().getAddress());
        }
        if (address.hasEnvoyInternalAddress()) {
            return StringUtil.isNotBlank((String)address.getEnvoyInternalAddress().getEndpointId()) && address.getEnvoyInternalAddress().getEndpointId().split(":").length == 2;
        }
        return false;
    }

    public static String getAddressIP(Address address) {
        if (Objects.isNull(address)) {
            return null;
        }
        if (address.hasSocketAddress()) {
            return address.getSocketAddress().getAddress();
        }
        if (address.hasEnvoyInternalAddress()) {
            return address.getEnvoyInternalAddress().getEndpointId().split(":")[0];
        }
        return null;
    }
}

