/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.common.stream.CancellableStreamMessage;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.common.stream.NoopCancellableStreamMessage;
import com.linecorp.armeria.common.stream.NoopSubscriber;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.CompletionActions;
import com.linecorp.armeria.common.util.CompositeException;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.internal.common.stream.AbortingSubscriber;
import com.linecorp.armeria.internal.common.stream.InternalStreamMessageUtil;
import com.linecorp.armeria.internal.common.stream.SubscriberUtil;
import com.linecorp.armeria.unsafe.PooledObjects;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@UnstableApi
public class DeferredStreamMessage<T>
extends CancellableStreamMessage<T> {
    private static final AtomicReferenceFieldUpdater<DeferredStreamMessage, CancellableStreamMessage.SubscriptionImpl> downstreamSubscriptionUpdater = AtomicReferenceFieldUpdater.newUpdater(DeferredStreamMessage.class, CancellableStreamMessage.SubscriptionImpl.class, "downstreamSubscription");
    private static final AtomicReferenceFieldUpdater<DeferredStreamMessage, StreamMessage> upstreamUpdater = AtomicReferenceFieldUpdater.newUpdater(DeferredStreamMessage.class, StreamMessage.class, "upstream");
    private static final AtomicIntegerFieldUpdater<DeferredStreamMessage> subscribedToUpstreamUpdater = AtomicIntegerFieldUpdater.newUpdater(DeferredStreamMessage.class, "subscribedToUpstream");
    private static final AtomicReferenceFieldUpdater<DeferredStreamMessage, Throwable> abortCauseUpdater = AtomicReferenceFieldUpdater.newUpdater(DeferredStreamMessage.class, Throwable.class, "abortCause");
    private static final AtomicReferenceFieldUpdater<DeferredStreamMessage, CompletableFuture> collectingFutureUpdater = AtomicReferenceFieldUpdater.newUpdater(DeferredStreamMessage.class, CompletableFuture.class, "collectingFuture");
    private static final CompletableFuture<List<?>> NO_COLLECTING_FUTURE = UnmodifiableFuture.completedFuture(null);
    private static final CancellableStreamMessage.SubscriptionImpl NOOP_SUBSCRIPTION = DeferredStreamMessage.noopSubscription();
    @Nullable
    private final EventExecutor defaultSubscriberExecutor;
    @Nullable
    private volatile StreamMessage<T> upstream;
    @Nullable
    private Subscription upstreamSubscription;
    @Nullable
    private volatile CancellableStreamMessage.SubscriptionImpl downstreamSubscription;
    @Nullable
    private volatile CompletableFuture<List<T>> collectingFuture;
    @Nullable
    private SubscriptionOption[] collectionOptions;
    @Nullable
    private EventExecutor collectingExecutor;
    private volatile int subscribedToUpstream;
    private long pendingDemand;
    @Nullable
    private volatile Throwable abortCause;
    private boolean downstreamOnSubscribeCalled;

    public DeferredStreamMessage() {
        this.defaultSubscriberExecutor = null;
    }

    public DeferredStreamMessage(EventExecutor defaultSubscriberExecutor) {
        this.defaultSubscriberExecutor = Objects.requireNonNull(defaultSubscriberExecutor, "defaultSubscriberExecutor");
    }

    @Override
    public EventExecutor defaultSubscriberExecutor() {
        if (this.defaultSubscriberExecutor != null) {
            return this.defaultSubscriberExecutor;
        }
        return super.defaultSubscriberExecutor();
    }

    protected final void delegateOnCompletion(CompletionStage<? extends Publisher<T>> stage) {
        Objects.requireNonNull(stage, "stage");
        stage.handle((upstream, thrown) -> {
            if (thrown != null) {
                this.close(Exceptions.peel(thrown));
            } else if (upstream == null) {
                this.close(new NullPointerException("upstream stage produced a null stream message: " + stage));
            } else {
                this.delegate(StreamMessage.of(upstream));
            }
            return null;
        });
    }

    protected final void delegate(StreamMessage<T> upstream) {
        Objects.requireNonNull(upstream, "upstream");
        if (!upstreamUpdater.compareAndSet(this, null, upstream)) {
            IllegalStateException exception = new IllegalStateException("upstream set already");
            upstream.abort(exception);
            throw exception;
        }
        Throwable abortCause = this.abortCause;
        if (abortCause != null) {
            upstream.abort(abortCause);
        }
        if (!collectingFutureUpdater.compareAndSet(this, null, NO_COLLECTING_FUTURE)) {
            assert (this.collectingExecutor != null);
            assert (this.collectionOptions != null);
            upstream.collect(this.collectingExecutor, this.collectionOptions).handle((result, cause) -> {
                CompletableFuture<List<List>> collectingFuture = this.collectingFuture;
                assert (collectingFuture != null);
                if (cause != null) {
                    collectingFuture.completeExceptionally((Throwable)cause);
                } else if (!collectingFuture.complete((List<List>)result)) {
                    for (Object obj : result) {
                        PooledObjects.close(obj);
                    }
                }
                return null;
            });
        }
        if (!this.whenComplete().isDone()) {
            ((CompletableFuture)upstream.whenComplete().handle((unused, cause) -> {
                if (cause == null) {
                    this.whenComplete().complete(null);
                } else {
                    this.whenComplete().completeExceptionally((Throwable)cause);
                }
                return null;
            })).exceptionally(CompletionActions::log);
        }
        this.safeOnSubscribeToUpstream();
    }

    public final void close() {
        this.delegate(StreamMessage.of());
    }

    public final void close(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        this.delegate(StreamMessage.aborted(cause));
    }

    @Override
    public final boolean isOpen() {
        StreamMessage<T> upstream = this.upstream;
        if (upstream != null) {
            return upstream.isOpen();
        }
        return !this.whenComplete().isDone();
    }

    @Override
    public final boolean isEmpty() {
        StreamMessage<T> upstream = this.upstream;
        if (upstream != null) {
            return upstream.isEmpty();
        }
        return !this.isOpen();
    }

    @Override
    public final long demand() {
        return this.pendingDemand;
    }

    @Override
    final void request(long n) {
        CancellableStreamMessage.SubscriptionImpl downstreamSubscription = this.downstreamSubscription;
        assert (downstreamSubscription != null);
        if (downstreamSubscription.needsDirectInvocation()) {
            this.doRequest(n);
        } else {
            downstreamSubscription.executor().execute(() -> this.doRequest(n));
        }
    }

    private void doRequest(long n) {
        Subscription upstreamSubscription = this.upstreamSubscription;
        if (upstreamSubscription != null) {
            upstreamSubscription.request(n);
        } else {
            this.pendingDemand += n;
        }
    }

    @Override
    final void cancel() {
        CancellableStreamMessage.SubscriptionImpl downstreamSubscription = this.downstreamSubscription;
        assert (downstreamSubscription != null);
        if (downstreamSubscription.needsDirectInvocation()) {
            this.doCancel();
        } else {
            downstreamSubscription.executor().execute(this::doCancel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCancel() {
        Subscription upstreamSubscription = this.upstreamSubscription;
        if (upstreamSubscription != null) {
            try {
                upstreamSubscription.cancel();
            }
            finally {
                StreamMessage<T> upstream = this.upstream;
                assert (upstream != null);
                CancellableStreamMessage.SubscriptionImpl downstreamSubscription = this.downstreamSubscription;
                assert (downstreamSubscription != null);
                if (upstream.isComplete()) {
                    downstreamSubscription.clearSubscriber();
                } else {
                    upstream.whenComplete().handle((u1, u2) -> {
                        downstreamSubscription.clearSubscriber();
                        return null;
                    });
                }
            }
        } else {
            this.abort(CancelledSubscriptionException.get());
        }
    }

    @Override
    final CancellableStreamMessage.SubscriptionImpl subscribe(CancellableStreamMessage.SubscriptionImpl subscription) {
        if (!downstreamSubscriptionUpdater.compareAndSet(this, null, subscription)) {
            CancellableStreamMessage.SubscriptionImpl oldSubscription = this.downstreamSubscription;
            assert (oldSubscription != null);
            return oldSubscription;
        }
        Subscriber<Object> subscriber = subscription.subscriber();
        if (subscription.needsDirectInvocation()) {
            this.subscribe(subscription, subscriber);
        } else {
            subscription.executor().execute(() -> this.subscribe(subscription, subscriber));
        }
        return subscription;
    }

    private void subscribe(CancellableStreamMessage.SubscriptionImpl subscription, Subscriber<Object> subscriber) {
        if (this.downstreamOnSubscribeCalled) {
            return;
        }
        this.downstreamOnSubscribeCalled = true;
        try {
            subscriber.onSubscribe((Subscription)subscription);
        }
        catch (Throwable t) {
            this.abort(t);
            Exceptions.throwIfFatal(t);
            logger.warn("Subscriber.onSubscribe() should not raise an exception. subscriber: {}", subscriber, (Object)t);
            return;
        }
        this.safeOnSubscribeToUpstream();
    }

    private void safeOnSubscribeToUpstream() {
        StreamMessage<T> upstream = this.upstream;
        CancellableStreamMessage.SubscriptionImpl downstreamSubscription = this.downstreamSubscription;
        if (upstream == null || downstreamSubscription == null || downstreamSubscription == NOOP_SUBSCRIPTION) {
            return;
        }
        if (!subscribedToUpstreamUpdater.compareAndSet(this, 0, 1)) {
            return;
        }
        upstream.subscribe(new ForwardingSubscriber(downstreamSubscription.subscriber()), downstreamSubscription.executor(), downstreamSubscription.options());
    }

    @Override
    public final void abort() {
        this.abort(AbortedStreamException.get());
    }

    @Override
    public final void abort(Throwable cause) {
        CancellableStreamMessage.SubscriptionImpl newSubscription;
        Objects.requireNonNull(cause, "cause");
        if (!abortCauseUpdater.compareAndSet(this, null, cause)) {
            return;
        }
        if (!subscribedToUpstreamUpdater.compareAndSet(this, 0, 1)) {
            StreamMessage<T> upstream = this.upstream;
            assert (upstream != null);
            upstream.abort(cause);
            return;
        }
        StreamMessage<T> upstream = this.upstream;
        if (upstream != null) {
            upstream.abort(cause);
        }
        if (downstreamSubscriptionUpdater.compareAndSet(this, null, newSubscription = new CancellableStreamMessage.SubscriptionImpl(this, AbortingSubscriber.get(cause), (EventExecutor)ImmediateEventExecutor.INSTANCE, InternalStreamMessageUtil.EMPTY_OPTIONS))) {
            this.whenComplete().completeExceptionally(cause);
            return;
        }
        CompletableFuture<List<T>> collectingFuture = this.collectingFuture;
        if (collectingFuture != null && collectingFuture != NO_COLLECTING_FUTURE) {
            collectingFuture.completeExceptionally(cause);
        }
        CancellableStreamMessage.SubscriptionImpl downstreamSubscription = this.downstreamSubscription;
        assert (downstreamSubscription != null);
        if (downstreamSubscription.needsDirectInvocation()) {
            this.downstreamOnError(cause, downstreamSubscription);
        } else {
            downstreamSubscription.executor().execute(() -> this.downstreamOnError(cause, downstreamSubscription));
        }
    }

    private void downstreamOnError(Throwable cause, CancellableStreamMessage.SubscriptionImpl downstreamSubscription) {
        Subscriber<Object> subscriber = downstreamSubscription.subscriber();
        try {
            if (!this.downstreamOnSubscribeCalled) {
                this.downstreamOnSubscribeCalled = true;
                subscriber.onSubscribe((Subscription)downstreamSubscription);
            }
            if (downstreamSubscription.shouldNotifyCancellation() || !(cause instanceof CancelledSubscriptionException)) {
                subscriber.onError(cause);
            }
        }
        catch (Throwable t) {
            CompositeException composite = new CompositeException(t, cause);
            Exceptions.throwIfFatal(t);
            logger.warn("Subscriber.onSubscribe() or onError() should not raise an exception. subscriber: {}", subscriber, (Object)composite);
        }
        this.whenComplete().completeExceptionally(cause);
    }

    @Override
    public CompletableFuture<List<T>> collect(EventExecutor executor, SubscriptionOption ... options) {
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(options, "options");
        if (!downstreamSubscriptionUpdater.compareAndSet(this, null, NOOP_SUBSCRIPTION)) {
            CancellableStreamMessage.SubscriptionImpl downstreamSubscription = this.downstreamSubscription;
            assert (downstreamSubscription != null);
            Subscriber<Object> subscriber = downstreamSubscription.subscriber();
            Throwable cause = SubscriberUtil.abortedOrLate(subscriber);
            CompletableFuture<List<T>> collectingFuture = new CompletableFuture<List<T>>();
            collectingFuture.completeExceptionally(cause);
            return collectingFuture;
        }
        StreamMessage<T> upstream = this.upstream;
        if (upstream != null) {
            return upstream.collect(executor, options);
        }
        CompletableFuture<List<T>> collectingFuture = new CompletableFuture<List<T>>();
        this.collectingExecutor = executor;
        this.collectionOptions = options;
        if (collectingFutureUpdater.compareAndSet(this, null, collectingFuture)) {
            Throwable abortCause = this.abortCause;
            if (abortCause != null) {
                collectingFuture.completeExceptionally(abortCause);
            }
            return collectingFuture;
        }
        StreamMessage<T> upstream0 = this.upstream;
        assert (upstream0 != null);
        return upstream0.collect(executor, options);
    }

    private static CancellableStreamMessage.SubscriptionImpl noopSubscription() {
        return new CancellableStreamMessage.SubscriptionImpl(NoopCancellableStreamMessage.INSTANCE, NoopSubscriber.get(), (EventExecutor)ImmediateEventExecutor.INSTANCE, InternalStreamMessageUtil.EMPTY_OPTIONS);
    }

    private final class ForwardingSubscriber
    implements Subscriber<T> {
        private final Subscriber<Object> downstreamSubscriber;

        ForwardingSubscriber(Subscriber<Object> downstreamSubscriber) {
            this.downstreamSubscriber = downstreamSubscriber;
        }

        public void onSubscribe(Subscription subscription) {
            DeferredStreamMessage.this.upstreamSubscription = subscription;
            if (DeferredStreamMessage.this.pendingDemand > 0L) {
                DeferredStreamMessage.this.upstreamSubscription.request(DeferredStreamMessage.this.pendingDemand);
                DeferredStreamMessage.this.pendingDemand = 0L;
            }
        }

        public void onNext(T t) {
            this.downstreamSubscriber.onNext(t);
        }

        public void onError(Throwable t) {
            this.downstreamSubscriber.onError(t);
        }

        public void onComplete() {
            this.downstreamSubscriber.onComplete();
        }
    }
}

