/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.annotation;

import com.linecorp.armeria.common.DependencyInjector;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import com.linecorp.armeria.internal.server.annotation.AnnotatedBeanFactory;
import com.linecorp.armeria.internal.server.annotation.AnnotatedValueResolver;
import com.linecorp.armeria.internal.server.annotation.AnnotationUtil;
import com.linecorp.armeria.internal.shaded.fastutil.objects.Object2ObjectOpenHashMap;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Predicate;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import com.linecorp.armeria.internal.shaded.guava.primitives.Ints;
import com.linecorp.armeria.internal.shaded.reflections.ReflectionUtils;
import com.linecorp.armeria.server.annotation.RequestConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AnnotatedBeanFactoryRegistry {
    private static final Logger logger = LoggerFactory.getLogger(AnnotatedBeanFactoryRegistry.class);
    private static final ReentrantLock lock = new ReentrantShortLock();
    private static final ClassValue<AnnotatedBeanFactories> factories = new ClassValue<AnnotatedBeanFactories>(){

        @Override
        protected AnnotatedBeanFactories computeValue(Class<?> type) {
            return new AnnotatedBeanFactories();
        }
    };
    private static final AnnotatedBeanFactory<?> unsupportedBeanFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BeanFactoryId register(Class<?> clazz, Set<String> pathParams, List<AnnotatedValueResolver.RequestObjectResolver> objectResolvers, DependencyInjector dependencyInjector) {
        lock.lock();
        try {
            BeanFactoryId beanFactoryId = new BeanFactoryId(clazz, pathParams);
            AnnotatedBeanFactories annotatedBeanFactories = factories.get(clazz);
            if (!annotatedBeanFactories.containsKey(beanFactoryId.pathParams)) {
                AnnotatedBeanFactory factory = AnnotatedBeanFactoryRegistry.createFactory(beanFactoryId, objectResolvers, dependencyInjector);
                if (factory != null) {
                    annotatedBeanFactories.put(beanFactoryId.pathParams, factory);
                    logger.debug("Registered a bean factory: {}", (Object)beanFactoryId);
                } else {
                    annotatedBeanFactories.put(beanFactoryId.pathParams, unsupportedBeanFactory);
                }
            }
            BeanFactoryId beanFactoryId2 = beanFactoryId;
            return beanFactoryId2;
        }
        finally {
            lock.unlock();
        }
    }

    @Nullable
    static AnnotatedBeanFactory<?> find(@Nullable BeanFactoryId beanFactoryId) {
        if (beanFactoryId == null) {
            return null;
        }
        AnnotatedBeanFactories annotatedBeanFactories = factories.get(beanFactoryId.type);
        AnnotatedBeanFactory<?> factory = annotatedBeanFactories.get(beanFactoryId.pathParams);
        return factory != null && factory != unsupportedBeanFactory ? factory : null;
    }

    static Set<AnnotatedValueResolver> uniqueResolverSet() {
        return new TreeSet<AnnotatedValueResolver>((o1, o2) -> {
            int result;
            Class<? extends Annotation> o2AnnotationType;
            String o1Name = o1.httpElementName();
            String o2Name = o2.httpElementName();
            Class<? extends Annotation> o1AnnotationType = o1.annotationType();
            if (o1AnnotationType == (o2AnnotationType = o2.annotationType()) && o1Name.equals(o2Name)) {
                return 0;
            }
            if (o1AnnotationType != null) {
                o1Name = o1Name + '/' + o1AnnotationType.getName();
            }
            if (o2AnnotationType != null) {
                o2Name = o2Name + '/' + o2AnnotationType.getName();
            }
            if ((result = o1Name.compareTo(o2Name)) != 0) {
                return result;
            }
            return Ints.compare(Objects.hashCode(o1AnnotationType), Objects.hashCode(o2AnnotationType));
        });
    }

    static void warnDuplicateResolver(AnnotatedValueResolver resolver, String genericString) {
        assert (resolver.annotationType() != null);
        logger.warn("Ignoring a duplicate injection target '@{}(\"{}\")' at '{}'", new Object[]{resolver.annotationType().getSimpleName(), resolver.httpElementName(), genericString});
    }

    @Nullable
    private static <T> AnnotatedBeanFactory<T> createFactory(BeanFactoryId beanFactoryId, List<AnnotatedValueResolver.RequestObjectResolver> objectResolvers, DependencyInjector dependencyInjector) {
        Objects.requireNonNull(beanFactoryId, "beanFactoryId");
        Objects.requireNonNull(objectResolvers, "objectResolvers");
        int modifiers = beanFactoryId.type.getModifiers();
        if (Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers)) {
            return null;
        }
        List<AnnotatedValueResolver.RequestObjectResolver> resolvers = AnnotatedValueResolver.addToFirstIfExists(objectResolvers, AnnotationUtil.findDeclared(beanFactoryId.type, RequestConverter.class), dependencyInjector);
        Map.Entry<Constructor<T>, List<AnnotatedValueResolver>> constructor = AnnotatedBeanFactoryRegistry.findConstructor(beanFactoryId, resolvers, dependencyInjector);
        if (constructor == null) {
            return null;
        }
        List<AnnotatedValueResolver> constructorAnnotatedResolvers = constructor.getValue();
        Map<Method, List<AnnotatedValueResolver>> methods = AnnotatedBeanFactoryRegistry.findMethods(constructorAnnotatedResolvers, beanFactoryId, resolvers, dependencyInjector);
        Map<Field, AnnotatedValueResolver> fields = AnnotatedBeanFactoryRegistry.findFields(constructorAnnotatedResolvers, methods, beanFactoryId, resolvers, dependencyInjector);
        if (constructor.getValue().isEmpty() && methods.isEmpty() && fields.isEmpty()) {
            return null;
        }
        constructor.getKey().setAccessible(true);
        methods.keySet().forEach(method -> method.setAccessible(true));
        fields.keySet().forEach(field -> field.setAccessible(true));
        return new AnnotatedBeanFactory<T>(beanFactoryId, constructor, methods, fields);
    }

    @Nullable
    private static <T> Map.Entry<Constructor<T>, List<AnnotatedValueResolver>> findConstructor(BeanFactoryId beanFactoryId, List<AnnotatedValueResolver.RequestObjectResolver> objectResolvers, DependencyInjector dependencyInjector) {
        AbstractMap.SimpleImmutableEntry<Constructor, List<Object>> candidate = null;
        Set<Constructor> constructors = ReflectionUtils.getConstructors(beanFactoryId.type, new Predicate[0]);
        for (Constructor constructor : constructors) {
            if (constructor.getParameterCount() == 0 && candidate == null) {
                candidate = new AbstractMap.SimpleImmutableEntry(constructor, ImmutableList.of());
                continue;
            }
            try {
                List<RequestConverter> converters = AnnotationUtil.findDeclared(constructor, RequestConverter.class);
                List<AnnotatedValueResolver> resolvers = AnnotatedValueResolver.ofBeanConstructorOrMethod(constructor, beanFactoryId.pathParams, AnnotatedValueResolver.addToFirstIfExists(objectResolvers, converters, dependencyInjector), dependencyInjector);
                if (resolvers.isEmpty()) continue;
                if (candidate == null || ((List)candidate.getValue()).isEmpty()) {
                    candidate = new AbstractMap.SimpleImmutableEntry<Constructor, List<AnnotatedValueResolver>>(constructor, resolvers);
                    continue;
                }
                throw new IllegalArgumentException("too many annotated constructors in " + beanFactoryId.type.getSimpleName() + " (expected: 0 or 1)");
            }
            catch (AnnotatedValueResolver.NoAnnotatedParameterException noAnnotatedParameterException) {
            }
        }
        return candidate;
    }

    private static Map<Method, List<AnnotatedValueResolver>> findMethods(List<AnnotatedValueResolver> constructorAnnotatedResolvers, BeanFactoryId beanFactoryId, List<AnnotatedValueResolver.RequestObjectResolver> objectResolvers, DependencyInjector dependencyInjector) {
        Set<AnnotatedValueResolver> uniques = AnnotatedBeanFactoryRegistry.uniqueResolverSet();
        uniques.addAll(constructorAnnotatedResolvers);
        ImmutableMap.Builder<Method, List<AnnotatedValueResolver>> methodsBuilder = ImmutableMap.builder();
        Set<Method> methods = ReflectionUtils.getAllMethods(beanFactoryId.type, new Predicate[0]);
        for (Method method : methods) {
            List<RequestConverter> converters = AnnotationUtil.findDeclared(method, RequestConverter.class);
            try {
                List<AnnotatedValueResolver> resolvers = AnnotatedValueResolver.ofBeanConstructorOrMethod(method, beanFactoryId.pathParams, AnnotatedValueResolver.addToFirstIfExists(objectResolvers, converters, dependencyInjector), dependencyInjector);
                if (resolvers.isEmpty()) continue;
                ArrayList<AnnotatedValueResolver> duplicateResolvers = new ArrayList<AnnotatedValueResolver>(resolvers.size());
                for (AnnotatedValueResolver resolver : resolvers) {
                    if (uniques.add(resolver)) continue;
                    duplicateResolvers.add(resolver);
                }
                if (duplicateResolvers.size() == resolvers.size()) continue;
                for (AnnotatedValueResolver duplicateResolver : duplicateResolvers) {
                    AnnotatedBeanFactoryRegistry.warnDuplicateResolver(duplicateResolver, method.toGenericString());
                }
                methodsBuilder.put(method, resolvers);
            }
            catch (AnnotatedValueResolver.NoAnnotatedParameterException noAnnotatedParameterException) {}
        }
        return methodsBuilder.build();
    }

    private static Map<Field, AnnotatedValueResolver> findFields(List<AnnotatedValueResolver> constructorAnnotatedResolvers, Map<Method, List<AnnotatedValueResolver>> methods, BeanFactoryId beanFactoryId, List<AnnotatedValueResolver.RequestObjectResolver> objectResolvers, DependencyInjector dependencyInjector) {
        Set<AnnotatedValueResolver> uniques = AnnotatedBeanFactoryRegistry.uniqueResolverSet();
        uniques.addAll(constructorAnnotatedResolvers);
        methods.values().forEach(uniques::addAll);
        ImmutableMap.Builder<Field, AnnotatedValueResolver> builder = ImmutableMap.builder();
        Set<Field> fields = ReflectionUtils.getAllFields(beanFactoryId.type, new Predicate[0]);
        for (Field field : fields) {
            List<RequestConverter> converters = AnnotationUtil.findDeclared(field, RequestConverter.class);
            AnnotatedValueResolver resolver = AnnotatedValueResolver.ofBeanField(field, beanFactoryId.pathParams, AnnotatedValueResolver.addToFirstIfExists(objectResolvers, converters, dependencyInjector), dependencyInjector);
            if (resolver == null) continue;
            if (uniques.add(resolver)) {
                builder.put(field, resolver);
                continue;
            }
            AnnotatedBeanFactoryRegistry.warnDuplicateResolver(resolver, field.toGenericString());
        }
        return builder.build();
    }

    private AnnotatedBeanFactoryRegistry() {
    }

    static {
        BeanFactoryId beanFactoryId = new BeanFactoryId(Object.class, ImmutableSet.of());
        AbstractMap.SimpleImmutableEntry constructor = new AbstractMap.SimpleImmutableEntry(null, ImmutableList.of());
        unsupportedBeanFactory = new AnnotatedBeanFactory(beanFactoryId, constructor, ImmutableMap.of(), ImmutableMap.of());
    }

    static final class BeanFactoryId {
        private final Class<?> type;
        private final Set<String> pathParams;

        private BeanFactoryId(Class<?> type, Set<String> pathParams) {
            this.type = type;
            this.pathParams = ImmutableSortedSet.copyOf(pathParams);
        }

        Class<?> type() {
            return this.type;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            BeanFactoryId that = (BeanFactoryId)o;
            return this.type == that.type && this.pathParams.equals(that.pathParams);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.pathParams);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("type", this.type.getName()).add("pathParams", this.pathParams).toString();
        }
    }

    private static class AnnotatedBeanFactories {
        private final Map<Set<String>, AnnotatedBeanFactory<?>> factories = new Object2ObjectOpenHashMap();

        private AnnotatedBeanFactories() {
        }

        boolean containsKey(Set<String> pathParams) {
            return this.factories.containsKey(pathParams);
        }

        void put(Set<String> pathParams, AnnotatedBeanFactory<?> factory) {
            this.factories.put(pathParams, factory);
        }

        @Nullable
        AnnotatedBeanFactory<?> get(Set<String> pathParams) {
            return this.factories.get(pathParams);
        }
    }
}

