/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.annotation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.JacksonUtil;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import io.netty.util.AsciiString;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class JacksonRequestConverterFunction
implements RequestConverterFunction {
    private static final ObjectMapper defaultObjectMapper = JacksonUtil.newDefaultObjectMapper();
    private static final Map<Class<?>, Boolean> skippableTypes;
    private final ObjectMapper mapper;
    private final ConcurrentMap<Type, ObjectReader> readers = new ConcurrentHashMap<Type, ObjectReader>();

    public JacksonRequestConverterFunction() {
        this(defaultObjectMapper);
    }

    public JacksonRequestConverterFunction(ObjectMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper, "mapper");
    }

    @Override
    @Nullable
    public Object convertRequest(ServiceRequestContext ctx, AggregatedHttpRequest request, Class<?> expectedResultType, @Nullable ParameterizedType expectedParameterizedResultType) throws Exception {
        MediaType contentType = request.contentType();
        if (contentType != null && contentType.isJson()) {
            if (expectedResultType == TreeNode.class || expectedResultType == JsonNode.class) {
                try {
                    return this.mapper.readTree(JacksonRequestConverterFunction.getContent(request, contentType));
                }
                catch (JsonProcessingException e) {
                    throw JacksonRequestConverterFunction.newConversionException(e);
                }
            }
            ObjectReader reader = this.getObjectReader(expectedResultType, expectedParameterizedResultType);
            if (reader != null) {
                String content = JacksonRequestConverterFunction.getContent(request, contentType);
                try {
                    return reader.readValue(content);
                }
                catch (JsonProcessingException e) {
                    if (skippableTypes.containsKey(expectedResultType)) {
                        return RequestConverterFunction.fallthrough();
                    }
                    throw JacksonRequestConverterFunction.newConversionException(e);
                }
            }
        }
        return RequestConverterFunction.fallthrough();
    }

    private static String getContent(AggregatedHttpRequest request, MediaType contentType) {
        return request.content(contentType.charset(StandardCharsets.UTF_8));
    }

    @Nullable
    private ObjectReader getObjectReader(Class<?> expectedResultType, @Nullable ParameterizedType expectedParameterizedResultType) {
        if (expectedParameterizedResultType != null) {
            return this.readers.computeIfAbsent(expectedParameterizedResultType, type -> this.mapper.readerFor((TypeReference)new TypeReference<Object>(){

                public Type getType() {
                    return type;
                }
            }));
        }
        return this.readers.computeIfAbsent(expectedResultType, type -> this.mapper.readerFor((Class)type));
    }

    private static IllegalArgumentException newConversionException(JsonProcessingException e) {
        return new IllegalArgumentException("failed to parse a JSON document: " + (Object)((Object)e), e);
    }

    static {
        IdentityHashMap<Class, Boolean> tmp = new IdentityHashMap<Class, Boolean>();
        tmp.put(byte[].class, true);
        tmp.put(HttpData.class, true);
        tmp.put(String.class, true);
        tmp.put(AsciiString.class, true);
        tmp.put(CharSequence.class, true);
        tmp.put(Object.class, true);
        skippableTypes = Collections.unmodifiableMap(tmp);
    }
}

