/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.observation;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.SimpleDecoratingHttpClient;
import com.linecorp.armeria.client.observation.ClientObservationContext;
import com.linecorp.armeria.client.observation.DefaultHttpClientObservationConvention;
import com.linecorp.armeria.client.observation.HttpClientObservationDocumentation;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.internal.common.RequestContextExtension;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.Objects;
import java.util.function.Function;

@UnstableApi
public final class ObservationClient
extends SimpleDecoratingHttpClient {
    private final ObservationRegistry observationRegistry;
    @Nullable
    private final ObservationConvention<ClientObservationContext> httpClientObservationConvention;

    public static Function<? super HttpClient, ObservationClient> newDecorator(ObservationRegistry observationRegistry) {
        Objects.requireNonNull(observationRegistry, "observationRegistry");
        return delegate -> new ObservationClient((HttpClient)delegate, observationRegistry, null);
    }

    public static Function<? super HttpClient, ObservationClient> newDecorator(ObservationRegistry observationRegistry, ObservationConvention<ClientObservationContext> observationConvention) {
        Objects.requireNonNull(observationRegistry, "observationRegistry");
        Objects.requireNonNull(observationConvention, "observationConvention");
        return delegate -> new ObservationClient((HttpClient)delegate, observationRegistry, observationConvention);
    }

    private ObservationClient(HttpClient delegate, ObservationRegistry observationRegistry, @Nullable ObservationConvention<ClientObservationContext> httpClientObservationConvention) {
        super(delegate);
        this.observationRegistry = Objects.requireNonNull(observationRegistry, "observationRegistry");
        this.httpClientObservationConvention = httpClientObservationConvention;
    }

    @Override
    public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        RequestHeadersBuilder newHeaders = req.headers().toBuilder();
        ClientObservationContext clientObservationContext = new ClientObservationContext(ctx, newHeaders, req);
        Observation observation = HttpClientObservationDocumentation.OBSERVATION.observation(this.httpClientObservationConvention, DefaultHttpClientObservationConvention.INSTANCE, () -> clientObservationContext, this.observationRegistry).start();
        HttpRequest newReq = req.withHeaders(newHeaders);
        ctx.updateRequest(newReq);
        RequestContextExtension ctxExtension = ctx.as(RequestContextExtension.class);
        if (this.observationRegistry.isNoop() || observation.isNoop()) {
            return (HttpResponse)((Client)this.unwrap()).execute(ctx, newReq);
        }
        if (ctxExtension != null) {
            ctxExtension.hook(observation::openScope);
        }
        ObservationClient.enrichObservation(ctx, clientObservationContext, observation);
        return observation.scopedChecked(() -> (HttpResponse)((Client)this.unwrap()).execute(ctx, newReq));
    }

    private static void enrichObservation(ClientRequestContext ctx, ClientObservationContext clientObservationContext, Observation observation) {
        ctx.log().whenAvailable(RequestLogProperty.REQUEST_FIRST_BYTES_TRANSFERRED_TIME).thenAccept(requestLog -> observation.event(HttpClientObservationDocumentation.Events.WIRE_SEND));
        ctx.log().whenAvailable(RequestLogProperty.RESPONSE_FIRST_BYTES_TRANSFERRED_TIME).thenAccept(requestLog -> {
            if (requestLog.responseFirstBytesTransferredTimeNanos() != null) {
                observation.event(HttpClientObservationDocumentation.Events.WIRE_RECEIVE);
            }
        });
        ctx.log().whenComplete().thenAccept(requestLog -> {
            clientObservationContext.setResponse(requestLog);
            observation.stop();
        });
    }
}

