/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.linecorp.armeria.common.HttpHeaders;
import io.netty.util.AsciiString;
import java.io.IOException;
import java.util.List;

final class HttpHeadersJsonSerializer
extends StdSerializer<HttpHeaders> {
    private static final long serialVersionUID = 4459242879396343114L;

    HttpHeadersJsonSerializer() {
        super(HttpHeaders.class);
    }

    @Override
    public void serialize(HttpHeaders headers, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        for (AsciiString name : headers.names()) {
            gen.writeFieldName(name.toString());
            List<String> values = headers.getAll(name);
            if (values.size() == 1) {
                gen.writeString(values.get(0));
                continue;
            }
            gen.writeStartArray();
            for (String value : values) {
                gen.writeString(value);
            }
            gen.writeEndArray();
        }
        gen.writeEndObject();
    }
}

