/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.annotation.Nullable;
import java.io.IOException;

final class MediaTypeJsonDeserializer
extends StdDeserializer<MediaType> {
    private static final long serialVersionUID = 2081299438299133097L;

    MediaTypeJsonDeserializer() {
        super(MediaType.class);
    }

    @Override
    @Nullable
    public MediaType deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        JsonNode tree = (JsonNode)p.getCodec().readTree(p);
        if (!tree.isTextual()) {
            ctx.reportInputMismatch(MediaType.class, "media type must be a string.", new Object[0]);
            return null;
        }
        String textValue = tree.textValue();
        try {
            return MediaType.parse(textValue);
        }
        catch (IllegalArgumentException unused) {
            ctx.reportInputMismatch(MediaType.class, "malformed media type: " + textValue, new Object[0]);
            return null;
        }
    }
}

