/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPPathModifier;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPPathModifierBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPPathModifierFluentImpl;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPURLRewriteFilter;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPURLRewriteFilterFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class HTTPURLRewriteFilterFluentImpl<A extends HTTPURLRewriteFilterFluent<A>>
extends BaseFluent<A>
implements HTTPURLRewriteFilterFluent<A> {
    private String hostname;
    private HTTPPathModifierBuilder path;
    private Map<String, Object> additionalProperties;

    public HTTPURLRewriteFilterFluentImpl() {
    }

    public HTTPURLRewriteFilterFluentImpl(HTTPURLRewriteFilter instance) {
        if (instance != null) {
            this.withHostname(instance.getHostname());
            this.withPath(instance.getPath());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    @Deprecated
    public HTTPPathModifier getPath() {
        return this.path != null ? this.path.build() : null;
    }

    @Override
    public HTTPPathModifier buildPath() {
        return this.path != null ? this.path.build() : null;
    }

    @Override
    public A withPath(HTTPPathModifier path) {
        this._visitables.get((Object)"path").remove(this.path);
        if (path != null) {
            this.path = new HTTPPathModifierBuilder(path);
            this._visitables.get((Object)"path").add(this.path);
        } else {
            this.path = null;
            this._visitables.get((Object)"path").remove(this.path);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPath() {
        return this.path != null;
    }

    @Override
    public A withNewPath(String replaceFullPath, String replacePrefixMatch, String type) {
        return this.withPath(new HTTPPathModifier(replaceFullPath, replacePrefixMatch, type));
    }

    @Override
    public HTTPURLRewriteFilterFluent.PathNested<A> withNewPath() {
        return new PathNestedImpl();
    }

    @Override
    public HTTPURLRewriteFilterFluent.PathNested<A> withNewPathLike(HTTPPathModifier item) {
        return new PathNestedImpl(item);
    }

    @Override
    public HTTPURLRewriteFilterFluent.PathNested<A> editPath() {
        return this.withNewPathLike(this.getPath());
    }

    @Override
    public HTTPURLRewriteFilterFluent.PathNested<A> editOrNewPath() {
        return this.withNewPathLike(this.getPath() != null ? this.getPath() : new HTTPPathModifierBuilder().build());
    }

    @Override
    public HTTPURLRewriteFilterFluent.PathNested<A> editOrNewPathLike(HTTPPathModifier item) {
        return this.withNewPathLike(this.getPath() != null ? this.getPath() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPURLRewriteFilterFluentImpl that = (HTTPURLRewriteFilterFluentImpl)o;
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.path, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class PathNestedImpl<N>
    extends HTTPPathModifierFluentImpl<HTTPURLRewriteFilterFluent.PathNested<N>>
    implements HTTPURLRewriteFilterFluent.PathNested<N>,
    Nested<N> {
        HTTPPathModifierBuilder builder;

        PathNestedImpl(HTTPPathModifier item) {
            this.builder = new HTTPPathModifierBuilder(this, item);
        }

        PathNestedImpl() {
            this.builder = new HTTPPathModifierBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPURLRewriteFilterFluentImpl.this.withPath(this.builder.build());
        }

        @Override
        public N endPath() {
            return this.and();
        }
    }
}

