/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol.bean;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol.bean.ZabbixProtocolType;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol.bean.ZabbixResponse;

public class ZabbixResponseJsonSerializer
implements JsonSerializer<ZabbixResponse> {
    public JsonElement serialize(ZabbixResponse src, Type typeOfSrc, JsonSerializationContext context) {
        ZabbixProtocolType type = src.getType();
        JsonObject response = new JsonObject();
        response.addProperty("response", "success");
        if (type == ZabbixProtocolType.ACTIVE_CHECKS) {
            response.add("data", new Gson().toJsonTree(src.getActiveChecks()));
        } else if (type == ZabbixProtocolType.AGENT_DATA) {
            response.addProperty("info", src.getAgentData().getInfo());
        }
        return response;
    }
}

