/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.trace.v1.BanyandbTrace;
import org.apache.skywalking.banyandb.v1.client.AbstractWrite;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.metadata.MetadataCache;
import org.apache.skywalking.banyandb.v1.client.metadata.Serializable;

public class TraceWrite
extends AbstractWrite<BanyandbTrace.WriteRequest> {
    private ByteString span = ByteString.EMPTY;
    private long version = 1L;

    TraceWrite(MetadataCache.EntityMetadata entityMetadata) {
        super(entityMetadata);
    }

    public TraceWrite tag(String tagName, Serializable<BanyandbModel.TagValue> tagValue) throws BanyanDBException {
        return (TraceWrite)super.tag(tagName, tagValue);
    }

    public TraceWrite span(byte[] span) {
        this.span = ByteString.copyFrom((byte[])span);
        return this;
    }

    public TraceWrite span(ByteString span) {
        this.span = span;
        return this;
    }

    public TraceWrite version(long version) {
        this.version = version;
        return this;
    }

    @Override
    protected BanyandbTrace.WriteRequest build(BanyandbCommon.Metadata metadata) {
        BanyandbTrace.WriteRequest.Builder builder = BanyandbTrace.WriteRequest.newBuilder();
        builder.setMetadata(metadata);
        ArrayList<BanyandbModel.TagValue> tagValues = new ArrayList<BanyandbModel.TagValue>();
        for (int i = 0; i < this.tags.length; ++i) {
            Object obj = this.tags[i];
            if (obj == null) continue;
            tagValues.add((BanyandbModel.TagValue)((Serializable)obj).serialize());
        }
        builder.addAllTags(tagValues);
        builder.setSpan(this.span);
        builder.setVersion(this.version);
        return builder.build();
    }

    public ByteString getSpan() {
        return this.span;
    }

    public long getVersion() {
        return this.version;
    }
}

