/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;

public class BanyanDBStorageConfig
extends ModuleConfig {
    private Global global = new Global();
    private RecordsNormal recordsNormal = new RecordsNormal();
    private Trace trace = new Trace();
    private ZipkinTrace zipkinTrace = new ZipkinTrace();
    private RecordsTrace recordsTrace = new RecordsTrace();
    private RecordsZipkinTrace recordsZipkinTrace = new RecordsZipkinTrace();
    private RecordsLog recordsLog = new RecordsLog();
    private RecordsBrowserErrorLog recordsBrowserErrorLog = new RecordsBrowserErrorLog();
    private MetricsMin metricsMin = new MetricsMin();
    private MetricsHour metricsHour = new MetricsHour();
    private MetricsDay metricsDay = new MetricsDay();
    private Metadata metadata = new Metadata();
    private Property property = new Property();
    private Map<String, Map<String, TopN>> topNConfigs = new HashMap<String, Map<String, TopN>>();

    public String[] getTargetArray() {
        return (String[])Iterables.toArray((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)this.global.targets), String.class);
    }

    @Generated
    public Global getGlobal() {
        return this.global;
    }

    @Generated
    public RecordsNormal getRecordsNormal() {
        return this.recordsNormal;
    }

    @Generated
    public Trace getTrace() {
        return this.trace;
    }

    @Generated
    public ZipkinTrace getZipkinTrace() {
        return this.zipkinTrace;
    }

    @Generated
    public RecordsTrace getRecordsTrace() {
        return this.recordsTrace;
    }

    @Generated
    public RecordsZipkinTrace getRecordsZipkinTrace() {
        return this.recordsZipkinTrace;
    }

    @Generated
    public RecordsLog getRecordsLog() {
        return this.recordsLog;
    }

    @Generated
    public RecordsBrowserErrorLog getRecordsBrowserErrorLog() {
        return this.recordsBrowserErrorLog;
    }

    @Generated
    public MetricsMin getMetricsMin() {
        return this.metricsMin;
    }

    @Generated
    public MetricsHour getMetricsHour() {
        return this.metricsHour;
    }

    @Generated
    public MetricsDay getMetricsDay() {
        return this.metricsDay;
    }

    @Generated
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Generated
    public Property getProperty() {
        return this.property;
    }

    @Generated
    public Map<String, Map<String, TopN>> getTopNConfigs() {
        return this.topNConfigs;
    }

    @Generated
    public void setGlobal(Global global) {
        this.global = global;
    }

    @Generated
    public void setRecordsNormal(RecordsNormal recordsNormal) {
        this.recordsNormal = recordsNormal;
    }

    @Generated
    public void setTrace(Trace trace) {
        this.trace = trace;
    }

    @Generated
    public void setZipkinTrace(ZipkinTrace zipkinTrace) {
        this.zipkinTrace = zipkinTrace;
    }

    @Generated
    public void setRecordsTrace(RecordsTrace recordsTrace) {
        this.recordsTrace = recordsTrace;
    }

    @Generated
    public void setRecordsZipkinTrace(RecordsZipkinTrace recordsZipkinTrace) {
        this.recordsZipkinTrace = recordsZipkinTrace;
    }

    @Generated
    public void setRecordsLog(RecordsLog recordsLog) {
        this.recordsLog = recordsLog;
    }

    @Generated
    public void setRecordsBrowserErrorLog(RecordsBrowserErrorLog recordsBrowserErrorLog) {
        this.recordsBrowserErrorLog = recordsBrowserErrorLog;
    }

    @Generated
    public void setMetricsMin(MetricsMin metricsMin) {
        this.metricsMin = metricsMin;
    }

    @Generated
    public void setMetricsHour(MetricsHour metricsHour) {
        this.metricsHour = metricsHour;
    }

    @Generated
    public void setMetricsDay(MetricsDay metricsDay) {
        this.metricsDay = metricsDay;
    }

    @Generated
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setProperty(Property property) {
        this.property = property;
    }

    @Generated
    public void setTopNConfigs(Map<String, Map<String, TopN>> topNConfigs) {
        this.topNConfigs = topNConfigs;
    }

    public static class Global {
        private String targets = "127.0.0.1:17912";
        private int maxBulkSize = 5000;
        private int flushInterval = 15;
        private int flushTimeout = 10;
        private int concurrentWriteThreads = 2;
        private int profileTaskQueryMaxSize;
        private String user;
        private String password;
        private String sslTrustCAPath = "";
        private int asyncProfilerTaskQueryMaxSize;
        private int pprofTaskQueryMaxSize;
        private int resultWindowMaxSize = 10000;
        private int metadataQueryMaxSize = 5000;
        private int segmentQueryMaxSize = 200;
        private int profileDataQueryBatchSize = 100;
        private boolean cleanupUnusedTopNRules = true;
        private String namespace = "sw";

        @Generated
        public String getTargets() {
            return this.targets;
        }

        @Generated
        public int getMaxBulkSize() {
            return this.maxBulkSize;
        }

        @Generated
        public int getFlushInterval() {
            return this.flushInterval;
        }

        @Generated
        public int getFlushTimeout() {
            return this.flushTimeout;
        }

        @Generated
        public int getConcurrentWriteThreads() {
            return this.concurrentWriteThreads;
        }

        @Generated
        public int getProfileTaskQueryMaxSize() {
            return this.profileTaskQueryMaxSize;
        }

        @Generated
        public String getUser() {
            return this.user;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public String getSslTrustCAPath() {
            return this.sslTrustCAPath;
        }

        @Generated
        public int getAsyncProfilerTaskQueryMaxSize() {
            return this.asyncProfilerTaskQueryMaxSize;
        }

        @Generated
        public int getPprofTaskQueryMaxSize() {
            return this.pprofTaskQueryMaxSize;
        }

        @Generated
        public int getResultWindowMaxSize() {
            return this.resultWindowMaxSize;
        }

        @Generated
        public int getMetadataQueryMaxSize() {
            return this.metadataQueryMaxSize;
        }

        @Generated
        public int getSegmentQueryMaxSize() {
            return this.segmentQueryMaxSize;
        }

        @Generated
        public int getProfileDataQueryBatchSize() {
            return this.profileDataQueryBatchSize;
        }

        @Generated
        public boolean isCleanupUnusedTopNRules() {
            return this.cleanupUnusedTopNRules;
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Generated
        public void setTargets(String targets) {
            this.targets = targets;
        }

        @Generated
        public void setMaxBulkSize(int maxBulkSize) {
            this.maxBulkSize = maxBulkSize;
        }

        @Generated
        public void setFlushInterval(int flushInterval) {
            this.flushInterval = flushInterval;
        }

        @Generated
        public void setFlushTimeout(int flushTimeout) {
            this.flushTimeout = flushTimeout;
        }

        @Generated
        public void setConcurrentWriteThreads(int concurrentWriteThreads) {
            this.concurrentWriteThreads = concurrentWriteThreads;
        }

        @Generated
        public void setProfileTaskQueryMaxSize(int profileTaskQueryMaxSize) {
            this.profileTaskQueryMaxSize = profileTaskQueryMaxSize;
        }

        @Generated
        public void setUser(String user) {
            this.user = user;
        }

        @Generated
        public void setPassword(String password) {
            this.password = password;
        }

        @Generated
        public void setSslTrustCAPath(String sslTrustCAPath) {
            this.sslTrustCAPath = sslTrustCAPath;
        }

        @Generated
        public void setAsyncProfilerTaskQueryMaxSize(int asyncProfilerTaskQueryMaxSize) {
            this.asyncProfilerTaskQueryMaxSize = asyncProfilerTaskQueryMaxSize;
        }

        @Generated
        public void setPprofTaskQueryMaxSize(int pprofTaskQueryMaxSize) {
            this.pprofTaskQueryMaxSize = pprofTaskQueryMaxSize;
        }

        @Generated
        public void setResultWindowMaxSize(int resultWindowMaxSize) {
            this.resultWindowMaxSize = resultWindowMaxSize;
        }

        @Generated
        public void setMetadataQueryMaxSize(int metadataQueryMaxSize) {
            this.metadataQueryMaxSize = metadataQueryMaxSize;
        }

        @Generated
        public void setSegmentQueryMaxSize(int segmentQueryMaxSize) {
            this.segmentQueryMaxSize = segmentQueryMaxSize;
        }

        @Generated
        public void setProfileDataQueryBatchSize(int profileDataQueryBatchSize) {
            this.profileDataQueryBatchSize = profileDataQueryBatchSize;
        }

        @Generated
        public void setCleanupUnusedTopNRules(boolean cleanupUnusedTopNRules) {
            this.cleanupUnusedTopNRules = cleanupUnusedTopNRules;
        }

        @Generated
        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }
    }

    public static class RecordsNormal
    extends GroupResource {
    }

    public static class Trace
    extends GroupResource {
    }

    public static class ZipkinTrace
    extends GroupResource {
    }

    public static class RecordsTrace
    extends GroupResource {
    }

    public static class RecordsZipkinTrace
    extends GroupResource {
    }

    public static class RecordsLog
    extends GroupResource {
    }

    public static class RecordsBrowserErrorLog
    extends GroupResource {
    }

    public static class MetricsMin
    extends GroupResource {
    }

    public static class MetricsHour
    extends GroupResource {
    }

    public static class MetricsDay
    extends GroupResource {
    }

    public static class Metadata
    extends GroupResource {
    }

    public static class Property
    extends GroupResource {
    }

    public static class TopN {
        private String name;
        private int lruSizeMinute = 10;
        private int lruSizeHourDay = 2;
        private int countersNumber = 1000;
        private List<String> groupByTagNames;
        private Sort sort = Sort.all;
        private Set<KeyValue> excludes = new HashSet<KeyValue>();

        @Generated
        public TopN() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public int getLruSizeMinute() {
            return this.lruSizeMinute;
        }

        @Generated
        public int getLruSizeHourDay() {
            return this.lruSizeHourDay;
        }

        @Generated
        public int getCountersNumber() {
            return this.countersNumber;
        }

        @Generated
        public List<String> getGroupByTagNames() {
            return this.groupByTagNames;
        }

        @Generated
        public Sort getSort() {
            return this.sort;
        }

        @Generated
        public Set<KeyValue> getExcludes() {
            return this.excludes;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setLruSizeMinute(int lruSizeMinute) {
            this.lruSizeMinute = lruSizeMinute;
        }

        @Generated
        public void setLruSizeHourDay(int lruSizeHourDay) {
            this.lruSizeHourDay = lruSizeHourDay;
        }

        @Generated
        public void setCountersNumber(int countersNumber) {
            this.countersNumber = countersNumber;
        }

        @Generated
        public void setGroupByTagNames(List<String> groupByTagNames) {
            this.groupByTagNames = groupByTagNames;
        }

        @Generated
        public void setSort(Sort sort) {
            this.sort = sort;
        }

        @Generated
        public void setExcludes(Set<KeyValue> excludes) {
            this.excludes = excludes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TopN)) {
                return false;
            }
            TopN other = (TopN)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLruSizeMinute() != other.getLruSizeMinute()) {
                return false;
            }
            if (this.getLruSizeHourDay() != other.getLruSizeHourDay()) {
                return false;
            }
            if (this.getCountersNumber() != other.getCountersNumber()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<String> this$groupByTagNames = this.getGroupByTagNames();
            List<String> other$groupByTagNames = other.getGroupByTagNames();
            if (this$groupByTagNames == null ? other$groupByTagNames != null : !((Object)this$groupByTagNames).equals(other$groupByTagNames)) {
                return false;
            }
            Sort this$sort = this.getSort();
            Sort other$sort = other.getSort();
            if (this$sort == null ? other$sort != null : !((Object)((Object)this$sort)).equals((Object)other$sort)) {
                return false;
            }
            Set<KeyValue> this$excludes = this.getExcludes();
            Set<KeyValue> other$excludes = other.getExcludes();
            return !(this$excludes == null ? other$excludes != null : !((Object)this$excludes).equals(other$excludes));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TopN;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLruSizeMinute();
            result = result * 59 + this.getLruSizeHourDay();
            result = result * 59 + this.getCountersNumber();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<String> $groupByTagNames = this.getGroupByTagNames();
            result = result * 59 + ($groupByTagNames == null ? 43 : ((Object)$groupByTagNames).hashCode());
            Sort $sort = this.getSort();
            result = result * 59 + ($sort == null ? 43 : ((Object)((Object)$sort)).hashCode());
            Set<KeyValue> $excludes = this.getExcludes();
            result = result * 59 + ($excludes == null ? 43 : ((Object)$excludes).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BanyanDBStorageConfig.TopN(name=" + this.getName() + ", lruSizeMinute=" + this.getLruSizeMinute() + ", lruSizeHourDay=" + this.getLruSizeHourDay() + ", countersNumber=" + this.getCountersNumber() + ", groupByTagNames=" + String.valueOf(this.getGroupByTagNames()) + ", sort=" + String.valueOf((Object)this.getSort()) + ", excludes=" + String.valueOf(this.getExcludes()) + ")";
        }

        public static enum Sort {
            all(BanyandbModel.Sort.SORT_UNSPECIFIED),
            des(BanyandbModel.Sort.SORT_DESC),
            asc(BanyandbModel.Sort.SORT_ASC);

            private final BanyandbModel.Sort banyandbSort;

            private Sort(BanyandbModel.Sort sort) {
                this.banyandbSort = sort;
            }

            @Generated
            public BanyandbModel.Sort getBanyandbSort() {
                return this.banyandbSort;
            }
        }
    }

    public static class GroupResource {
        private int shardNum;
        private int segmentInterval;
        private int ttl;
        private int replicas;
        private boolean enableWarmStage = false;
        private boolean enableColdStage = false;
        private List<String> defaultQueryStages = new ArrayList<String>(2);
        private List<Stage> additionalLifecycleStages = new ArrayList<Stage>(2);

        public GroupResource() {
            this.defaultQueryStages.add(StageName.hot.name());
        }

        @Generated
        public int getShardNum() {
            return this.shardNum;
        }

        @Generated
        public int getSegmentInterval() {
            return this.segmentInterval;
        }

        @Generated
        public int getTtl() {
            return this.ttl;
        }

        @Generated
        public int getReplicas() {
            return this.replicas;
        }

        @Generated
        public boolean isEnableWarmStage() {
            return this.enableWarmStage;
        }

        @Generated
        public boolean isEnableColdStage() {
            return this.enableColdStage;
        }

        @Generated
        public List<String> getDefaultQueryStages() {
            return this.defaultQueryStages;
        }

        @Generated
        public List<Stage> getAdditionalLifecycleStages() {
            return this.additionalLifecycleStages;
        }

        @Generated
        public void setShardNum(int shardNum) {
            this.shardNum = shardNum;
        }

        @Generated
        public void setSegmentInterval(int segmentInterval) {
            this.segmentInterval = segmentInterval;
        }

        @Generated
        public void setTtl(int ttl) {
            this.ttl = ttl;
        }

        @Generated
        public void setReplicas(int replicas) {
            this.replicas = replicas;
        }

        @Generated
        public void setEnableWarmStage(boolean enableWarmStage) {
            this.enableWarmStage = enableWarmStage;
        }

        @Generated
        public void setEnableColdStage(boolean enableColdStage) {
            this.enableColdStage = enableColdStage;
        }

        @Generated
        public void setDefaultQueryStages(List<String> defaultQueryStages) {
            this.defaultQueryStages = defaultQueryStages;
        }

        @Generated
        public void setAdditionalLifecycleStages(List<Stage> additionalLifecycleStages) {
            this.additionalLifecycleStages = additionalLifecycleStages;
        }
    }

    public static enum StageName {
        hot,
        warm,
        cold;

    }

    public static class Stage {
        private StageName name;
        private String nodeSelector;
        private int shardNum;
        private int segmentInterval;
        private int ttl;
        private int replicas;
        private boolean close = false;

        @Generated
        public StageName getName() {
            return this.name;
        }

        @Generated
        public String getNodeSelector() {
            return this.nodeSelector;
        }

        @Generated
        public int getShardNum() {
            return this.shardNum;
        }

        @Generated
        public int getSegmentInterval() {
            return this.segmentInterval;
        }

        @Generated
        public int getTtl() {
            return this.ttl;
        }

        @Generated
        public int getReplicas() {
            return this.replicas;
        }

        @Generated
        public boolean isClose() {
            return this.close;
        }

        @Generated
        public void setName(StageName name) {
            this.name = name;
        }

        @Generated
        public void setNodeSelector(String nodeSelector) {
            this.nodeSelector = nodeSelector;
        }

        @Generated
        public void setShardNum(int shardNum) {
            this.shardNum = shardNum;
        }

        @Generated
        public void setSegmentInterval(int segmentInterval) {
            this.segmentInterval = segmentInterval;
        }

        @Generated
        public void setTtl(int ttl) {
            this.ttl = ttl;
        }

        @Generated
        public void setReplicas(int replicas) {
            this.replicas = replicas;
        }

        @Generated
        public void setClose(boolean close) {
            this.close = close;
        }
    }
}

