/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import org.apache.skywalking.oap.server.core.storage.ttl.MetricsTTL;
import org.apache.skywalking.oap.server.core.storage.ttl.RecordsTTL;
import org.apache.skywalking.oap.server.core.storage.ttl.StorageTTLStatusQuery;
import org.apache.skywalking.oap.server.core.storage.ttl.TTLDefinition;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageConfig;

public class BanyanDBTTLStatusQuery
implements StorageTTLStatusQuery {
    private int grNormalTTLDays;
    private int grTraceTTLDays;
    private int grZipkinTraceTTLDays;
    private int grLogTTLDays;
    private int grBrowserErrorLogTTLDays;
    private int grSuperTTLDays;
    private int grColdNormalTTLDays = -1;
    private int grColdTraceTTLDays = -1;
    private int grColdZipkinTraceTTLDays = -1;
    private int grColdLogTTLDays = -1;
    private int grColdBrowserErrorLogTTLDays = -1;
    private int gmMinuteTTLDays;
    private int gmHourTTLDays;
    private int gmDayTTLDays;
    private int gmColdMinuteTTLDays = -1;
    private int gmColdHourTTLDays = -1;
    private int gmColdDayTTLDays = -1;

    public BanyanDBTTLStatusQuery(BanyanDBStorageConfig config) {
        this.grNormalTTLDays = config.getRecordsNormal().getTtl();
        this.grTraceTTLDays = config.getTrace().getTtl();
        this.grZipkinTraceTTLDays = config.getZipkinTrace().getTtl();
        this.grLogTTLDays = config.getRecordsLog().getTtl();
        this.grBrowserErrorLogTTLDays = config.getRecordsBrowserErrorLog().getTtl();
        this.gmMinuteTTLDays = config.getMetricsMin().getTtl();
        this.gmHourTTLDays = config.getMetricsHour().getTtl();
        this.gmDayTTLDays = config.getMetricsDay().getTtl();
        config.getRecordsNormal().getAdditionalLifecycleStages().forEach(stage -> {
            if (stage.getName().equals((Object)BanyanDBStorageConfig.StageName.warm)) {
                this.grNormalTTLDays += stage.getTtl();
            } else if (stage.getName().equals((Object)BanyanDBStorageConfig.StageName.cold)) {
                this.grColdNormalTTLDays = stage.getTtl();
            }
        });
        config.getTrace().getAdditionalLifecycleStages().forEach(stage -> {
            if (stage.getName().equals((Object)BanyanDBStorageConfig.StageName.warm)) {
                this.grTraceTTLDays += stage.getTtl();
            } else if (stage.getName().equals((Object)BanyanDBStorageConfig.StageName.cold)) {
                this.grColdTraceTTLDays = stage.getTtl();
            }
        });
        config.getZipkinTrace().getAdditionalLifecycleStages().forEach(stage -> {
            if (stage.getName().equals((Object)BanyanDBStorageConfig.StageName.warm)) {
                this.grZipkinTraceTTLDays += stage.getTtl();
            } else if (stage.getName().equals((Object)BanyanDBStorageConfig.StageName.cold)) {
                this.grColdZipkinTraceTTLDays = stage.getTtl();
            }
        });
        config.getRecordsLog().getAdditionalLifecycleStages().forEach(stage -> {
            if (stage.getName().equals((Object)BanyanDBStorageConfig.StageName.warm)) {
                this.grLogTTLDays += stage.getTtl();
            } else if (stage.getName().equals((Object)BanyanDBStorageConfig.StageName.cold)) {
                this.grColdLogTTLDays = stage.getTtl();
            }
        });
        config.getRecordsBrowserErrorLog().getAdditionalLifecycleStages().forEach(stage -> {
            if (stage.getName().equals((Object)BanyanDBStorageConfig.StageName.warm)) {
                this.grBrowserErrorLogTTLDays += stage.getTtl();
            } else if (stage.getName().equals((Object)BanyanDBStorageConfig.StageName.cold)) {
                this.grColdBrowserErrorLogTTLDays = stage.getTtl();
            }
        });
        config.getMetricsMin().getAdditionalLifecycleStages().forEach(stage -> {
            if (stage.getName().equals((Object)BanyanDBStorageConfig.StageName.warm)) {
                this.gmMinuteTTLDays += stage.getTtl();
            } else if (stage.getName().equals((Object)BanyanDBStorageConfig.StageName.cold)) {
                this.gmColdMinuteTTLDays = stage.getTtl();
            }
        });
        config.getMetricsHour().getAdditionalLifecycleStages().forEach(stage -> {
            if (stage.getName().equals((Object)BanyanDBStorageConfig.StageName.warm)) {
                this.gmHourTTLDays += stage.getTtl();
            } else if (stage.getName().equals((Object)BanyanDBStorageConfig.StageName.cold)) {
                this.gmColdHourTTLDays = stage.getTtl();
            }
        });
        config.getMetricsDay().getAdditionalLifecycleStages().forEach(stage -> {
            if (stage.getName().equals((Object)BanyanDBStorageConfig.StageName.warm)) {
                this.gmDayTTLDays += stage.getTtl();
            } else if (stage.getName().equals((Object)BanyanDBStorageConfig.StageName.cold)) {
                this.gmColdDayTTLDays = stage.getTtl();
            }
        });
    }

    public TTLDefinition getTTL() {
        TTLDefinition definition = new TTLDefinition(new MetricsTTL(this.gmMinuteTTLDays, this.gmHourTTLDays, this.gmDayTTLDays), new RecordsTTL(this.grNormalTTLDays, this.grTraceTTLDays, this.grZipkinTraceTTLDays, this.grLogTTLDays, this.grBrowserErrorLogTTLDays));
        definition.getRecords().setColdNormal(this.grColdNormalTTLDays);
        definition.getRecords().setColdTrace(this.grColdTraceTTLDays);
        definition.getRecords().setColdZipkinTrace(this.grColdZipkinTraceTTLDays);
        definition.getRecords().setColdLog(this.grColdLogTTLDays);
        definition.getRecords().setColdBrowserErrorLog(this.grColdBrowserErrorLogTTLDays);
        definition.getMetrics().setColdMinute(this.gmColdMinuteTTLDays);
        definition.getMetrics().setColdHour(this.gmColdHourTTLDays);
        definition.getMetrics().setColdDay(this.gmColdDayTTLDays);
        return definition;
    }
}

