/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.bulk;

import io.grpc.stub.StreamObserver;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.trace.v1.BanyandbTrace;
import org.apache.skywalking.banyandb.trace.v1.TraceServiceGrpc;
import org.apache.skywalking.banyandb.v1.client.BanyanDBClient;
import org.apache.skywalking.banyandb.v1.client.Options;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.util.StatusUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.bulk.AbstractBulkWriteProcessor;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class TraceBulkWriteProcessor
extends AbstractBulkWriteProcessor<BanyandbTrace.WriteRequest, TraceServiceGrpc.TraceServiceStub> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TraceBulkWriteProcessor.class);
    private final BanyanDBClient client;
    private final HistogramMetrics writeHistogram;
    private final Options options;

    public TraceBulkWriteProcessor(BanyanDBClient client, int maxBulkSize, int flushInterval, int concurrency, int timeout, HistogramMetrics writeHistogram, Options options) {
        super(client.getTraceServiceStub(), "TraceBulkWriteProcessor", maxBulkSize, flushInterval, concurrency, timeout);
        this.client = client;
        this.writeHistogram = writeHistogram;
        this.options = options;
    }

    @Override
    protected StreamObserver<BanyandbTrace.WriteRequest> buildStreamObserver(TraceServiceGrpc.TraceServiceStub stub, final CompletableFuture<Void> batch) {
        return stub.write((StreamObserver)new StreamObserver<BanyandbTrace.WriteResponse>(){
            private final Set<String> schemaExpired = new HashSet<String>();

            public void onNext(BanyandbTrace.WriteResponse writeResponse) {
                BanyandbModel.Status status = StatusUtil.convertStringToStatus((String)writeResponse.getStatus());
                switch (status) {
                    case STATUS_SUCCEED: {
                        break;
                    }
                    case STATUS_EXPIRED_SCHEMA: {
                        BanyandbCommon.Metadata metadata = writeResponse.getMetadata();
                        String schemaKey = metadata.getGroup() + "." + metadata.getName();
                        if (this.schemaExpired.contains(schemaKey)) break;
                        log.warn("The trace schema {} is expired, trying update the schema...", (Object)schemaKey);
                        try {
                            TraceBulkWriteProcessor.this.client.updateTraceMetadataCacheFromServer(metadata.getGroup(), metadata.getName());
                            this.schemaExpired.add(schemaKey);
                        }
                        catch (BanyanDBException e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                        break;
                    }
                    default: {
                        log.warn("Write trace failed with status: {}", (Object)status);
                    }
                }
            }

            public void onError(Throwable t) {
                batch.completeExceptionally(t);
                log.error("Error occurs in flushing traces", t);
            }

            public void onCompleted() {
                batch.complete(null);
            }
        });
    }

    @Override
    protected CompletableFuture<Void> doObservedFlush(List<AbstractBulkWriteProcessor.Holder> data) {
        HistogramMetrics.Timer timer = this.writeHistogram.createTimer();
        return super.doFlush(data, timer);
    }
}

