/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.measure;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.query.PointOfTime;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.MetricsCondition;
import org.apache.skywalking.oap.server.core.query.type.HeatMap;
import org.apache.skywalking.oap.server.core.query.type.IntValues;
import org.apache.skywalking.oap.server.core.query.type.KVInt;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.MetricsValues;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.util.ByteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBMetricsQueryDAO
extends AbstractBanyanDBDAO
implements IMetricsQueryDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanyanDBMetricsQueryDAO.class);

    public BanyanDBMetricsQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public MetricsValues readMetricsValues(MetricsCondition condition, String valueColumnName, Duration duration) throws IOException {
        String modelName = condition.getName();
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetricMetadata(modelName, duration.getStep());
        if (schema == null) {
            throw new IOException("schema is not registered");
        }
        String entityID = condition.getEntity().buildId();
        Map<Long, DataPoint> idMap = this.queryByEntityID(schema, valueColumnName, duration, entityID);
        List tsPoints = duration.assembleDurationPoints();
        MetricsValues metricsValues = new MetricsValues();
        IntValues intValues = metricsValues.getValues();
        for (PointOfTime ts : tsPoints) {
            String id = ts.id(entityID);
            KVInt kvInt = new KVInt();
            kvInt.setId(id);
            if (idMap.containsKey(ts.getPoint())) {
                DataPoint dataPoint = idMap.get(ts.getPoint());
                kvInt.setValue(this.extractFieldValue(schema, valueColumnName, dataPoint));
            } else {
                kvInt.setValue((long)ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName()));
                kvInt.setEmptyValue(true);
            }
            intValues.addKVInt(kvInt);
        }
        return metricsValues;
    }

    private long extractFieldValue(MetadataRegistry.Schema schema, String fieldName, DataPoint dataPoint) throws IOException {
        MetadataRegistry.ColumnSpec spec = schema.getSpec(fieldName);
        if (spec == null) {
            throw new IOException("field is not registered");
        }
        if (Double.TYPE.equals(spec.getColumnClass())) {
            return ByteUtil.bytes2Double((byte[])dataPoint.getFieldValue(fieldName)).longValue();
        }
        return ((Number)dataPoint.getFieldValue(fieldName)).longValue();
    }

    public List<MetricsValues> readLabeledMetricsValues(MetricsCondition condition, String valueColumnName, List<KeyValue> labels, Duration duration) throws IOException {
        Map<Long, DataPoint> idMap = this.queryByEntityID(condition, valueColumnName, duration);
        List tsPoints = duration.assembleDurationPoints();
        String entityID = condition.getEntity().buildId();
        ArrayList<String> ids = new ArrayList<String>(tsPoints.size());
        HashMap<String, DataTable> dataTableMap = new HashMap<String, DataTable>(idMap.size());
        for (PointOfTime ts : tsPoints) {
            String id = ts.id(entityID);
            ids.add(id);
            if (!idMap.containsKey(ts.getPoint())) continue;
            dataTableMap.put(id, new DataTable((String)idMap.get(ts.getPoint()).getFieldValue(valueColumnName)));
        }
        return IMetricsQueryDAO.Util.sortValues((List)IMetricsQueryDAO.Util.composeLabelValue((String)condition.getName(), labels, ids, dataTableMap), ids, (int)ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName()));
    }

    public List<MetricsValues> readLabeledMetricsValuesWithoutEntity(String metricsName, String valueColumnName, List<KeyValue> labels, Duration duration) throws IOException {
        boolean isColdStage = duration != null && duration.isColdStage();
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetricMetadata(metricsName, duration.getStep());
        if (schema == null) {
            throw new IOException("schema is not registered");
        }
        MeasureQueryResponse resp = this.query(isColdStage, schema, (Set<String>)ImmutableSet.of((Object)"entity_id"), (Set<String>)ImmutableSet.of((Object)valueColumnName), this.getTimestampRange(duration), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.limit(10);
            }
        });
        if (resp.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> ids = new ArrayList<String>(resp.size());
        HashMap<String, DataTable> dataTableMap = new HashMap<String, DataTable>();
        for (DataPoint dp : resp.getDataPoints()) {
            long timeBucket = TimeBucket.getTimeBucket((long)dp.getTimestamp(), (DownSampling)schema.getMetadata().getDownSampling());
            String entityID = (String)dp.getTagValue("entity_id");
            PointOfTime pt = new PointOfTime(timeBucket);
            String id = pt.id(entityID);
            ids.add(id);
            dataTableMap.put(id, new DataTable((String)dp.getFieldValue(valueColumnName)));
        }
        return IMetricsQueryDAO.Util.sortValues((List)IMetricsQueryDAO.Util.composeLabelValue((String)metricsName, labels, ids, dataTableMap), ids, (int)ValueColumnMetadata.INSTANCE.getDefaultValue(metricsName));
    }

    public HeatMap readHeatMap(MetricsCondition condition, String valueColumnName, Duration duration) throws IOException {
        Map<Long, DataPoint> idMap = this.queryByEntityID(condition, valueColumnName, duration);
        HeatMap heatMap = new HeatMap();
        if (idMap.isEmpty()) {
            return heatMap;
        }
        List tsPoints = duration.assembleDurationPoints();
        String entityID = condition.getEntity().buildId();
        ArrayList<String> ids = new ArrayList<String>(tsPoints.size());
        int defaultValue = ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName());
        for (PointOfTime ts : tsPoints) {
            String id = ts.id(entityID);
            ids.add(id);
            DataPoint dataPoint = idMap.get(ts.getPoint());
            if (dataPoint == null) continue;
            String value = (String)dataPoint.getFieldValue("dataset");
            heatMap.buildColumn(id, value, defaultValue);
        }
        heatMap.fixMissingColumns(ids, defaultValue);
        return heatMap;
    }

    private Map<Long, DataPoint> queryByEntityID(MetricsCondition condition, String valueColumnName, Duration duration) throws IOException {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetricMetadata(condition.getName(), duration.getStep());
        if (schema == null) {
            throw new IOException("schema is not registered");
        }
        return this.queryByEntityID(schema, valueColumnName, duration, condition.getEntity().buildId());
    }

    private Map<Long, DataPoint> queryByEntityID(MetadataRegistry.Schema schema, String valueColumnName, Duration duration, final String entityID) throws IOException {
        boolean isColdStage = duration != null && duration.isColdStage();
        HashMap<Long, DataPoint> map = new HashMap<Long, DataPoint>();
        MeasureQueryResponse resp = this.queryDebuggable(isColdStage, schema, (Set<String>)ImmutableSet.of((Object)"entity_id"), (Set<String>)ImmutableSet.of((Object)valueColumnName), this.getTimestampRange(duration), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.and(this.eq("entity_id", entityID));
            }
        });
        for (DataPoint dp : resp.getDataPoints()) {
            long timeBucket = TimeBucket.getTimeBucket((long)dp.getTimestamp(), (DownSampling)schema.getMetadata().getDownSampling());
            DataPoint preDp = map.putIfAbsent(timeBucket, dp);
            if (preDp == null) continue;
            log.warn("{}:{} returns duplicated data point at {}, pre:{}, current:{}", new Object[]{entityID, schema.getMetadata(), timeBucket, preDp.getFields(), dp.getFields()});
        }
        return map;
    }
}

