/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.RowEntity;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.oap.server.core.alarm.AlarmRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.AlarmMessage;
import org.apache.skywalking.oap.server.core.query.type.Alarms;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBConverter;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBAlarmQueryDAO
extends AbstractBanyanDBDAO
implements IAlarmQueryDAO {
    private static final Set<String> TAGS = ImmutableSet.of((Object)"scope", (Object)"name", (Object)"id0", (Object)"id1", (Object)"alarm_message", (Object)"start_time", (Object[])new String[]{"rule_name", "tags", "tags_raw_data", "snapshot"});

    public BanyanDBAlarmQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public Alarms getAlarm(final Integer scopeId, final String keyword, final int limit, final int from, Duration duration, final List<Tag> tags) throws IOException {
        boolean isColdStage = duration != null && duration.isColdStage();
        StreamQueryResponse resp = this.query(isColdStage, "alarm_record", TAGS, this.getTimestampRange(duration), new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            public void apply(StreamQuery query) {
                if (Objects.nonNull(scopeId)) {
                    query.and(this.eq("scope", scopeId.intValue()));
                }
                if (StringUtil.isNotEmpty((String)keyword)) {
                    query.and(this.match("alarm_message", keyword));
                }
                if (CollectionUtils.isNotEmpty((List)tags)) {
                    ArrayList<String> tagsConditions = new ArrayList<String>(tags.size());
                    for (Tag tag : tags) {
                        tagsConditions.add(tag.toString());
                    }
                    query.and(this.having("tags", tagsConditions));
                }
                query.setLimit(limit);
                query.setOffset(from);
                query.setOrderBy(new AbstractQuery.OrderBy(AbstractQuery.Sort.DESC));
            }
        });
        Alarms alarms = new Alarms();
        for (RowEntity rowEntity : resp.getElements()) {
            AlarmRecord.Builder builder = new AlarmRecord.Builder();
            AlarmRecord alarmRecord = builder.storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToStream("alarm_record", rowEntity));
            AlarmMessage alarmMessage = this.buildAlarmMessage(alarmRecord);
            if (!CollectionUtils.isEmpty((byte[])alarmRecord.getTagsRawData())) {
                this.parseDataBinary(alarmRecord.getTagsRawData(), alarmMessage.getTags());
            }
            alarms.getMsgs().add(alarmMessage);
        }
        return alarms;
    }
}

