/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.exporter.provider.kafka;

import com.google.gson.Gson;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.serialization.BytesSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.skywalking.oap.server.exporter.provider.ExporterSetting;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KafkaExportProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaExportProducer.class);
    protected final ExporterSetting setting;
    private volatile KafkaProducer<String, Bytes> producer;

    public KafkaExportProducer(ExporterSetting setting) {
        this.setting = setting;
    }

    protected KafkaProducer<String, Bytes> getProducer() {
        if (this.producer == null) {
            Properties properties = new Properties();
            properties.setProperty("bootstrap.servers", this.setting.getKafkaBootstrapServers());
            if (StringUtil.isNotEmpty((String)this.setting.getKafkaProducerConfig())) {
                Gson gson = new Gson();
                Properties override = (Properties)gson.fromJson(this.setting.getKafkaProducerConfig(), Properties.class);
                properties.putAll((Map<?, ?>)override);
            }
            this.producer = new KafkaProducer(properties, (Serializer)new StringSerializer(), (Serializer)new BytesSerializer());
        }
        return this.producer;
    }
}

