/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.profiling.pprof.storage.PprofProfilingDataRecord;
import org.apache.skywalking.oap.server.core.storage.profiling.pprof.IPprofDataQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.JDBCEntityConverters;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;

public class JDBCPprofDataQueryDAO
implements IPprofDataQueryDAO {
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;

    public List<PprofProfilingDataRecord> getByTaskIdAndInstances(String taskId, List<String> instanceIds) throws IOException {
        if (StringUtil.isBlank((String)taskId)) {
            return new ArrayList<PprofProfilingDataRecord>();
        }
        List<String> tables = this.tableHelper.getTablesWithinTTL("pprof_profiling_data");
        ArrayList<PprofProfilingDataRecord> results = new ArrayList<PprofProfilingDataRecord>();
        for (String table : tables) {
            ArrayList<String> condition = new ArrayList<String>(4);
            StringBuilder sql = new StringBuilder().append("select * from ").append(table).append(" where ").append("table_name").append(" = ?");
            condition.add("pprof_profiling_data");
            if (CollectionUtils.isNotEmpty(instanceIds)) {
                sql.append(" and ").append("instance_id").append(" in (?) ");
                String joinedInstanceIds = String.join((CharSequence)",", instanceIds);
                condition.add(joinedInstanceIds);
            }
            results.addAll((Collection)this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                ArrayList<PprofProfilingDataRecord> result = new ArrayList<PprofProfilingDataRecord>();
                while (resultSet.next()) {
                    result.add(this.parseData(resultSet));
                }
                return result;
            }, condition.toArray(new Object[0])));
        }
        return results;
    }

    private PprofProfilingDataRecord parseData(ResultSet data) {
        PprofProfilingDataRecord.Builder builder = new PprofProfilingDataRecord.Builder();
        PprofProfilingDataRecord pprofProfilingDataRecord = builder.storage2Entity(JDBCEntityConverters.toEntity(data));
        byte[] dataBinary = pprofProfilingDataRecord.getDataBinary();
        if (dataBinary != null) {
            byte[] decodeResult = Base64.getDecoder().decode(dataBinary);
            pprofProfilingDataRecord.setDataBinary(decodeResult);
        }
        return pprofProfilingDataRecord;
    }

    @Generated
    public JDBCPprofDataQueryDAO(JDBCClient jdbcClient, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
    }
}

