/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.PprofTaskLog;
import org.apache.skywalking.oap.server.core.query.type.PprofTaskLogOperationType;
import org.apache.skywalking.oap.server.core.storage.profiling.pprof.IPprofTaskLogQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.SQLAndParameters;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;

public class JDBCPprofTaskLogQueryDAO
implements IPprofTaskLogQueryDAO {
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;

    public List<PprofTaskLog> getTaskLogList() {
        List<String> tables = this.tableHelper.getTablesWithinTTL("pprof_task_log");
        ArrayList<PprofTaskLog> results = new ArrayList<PprofTaskLog>();
        for (String table : tables) {
            SQLAndParameters sqlAndParameters = this.buildSQL(table);
            List logs = (List)this.jdbcClient.executeQuery(sqlAndParameters.sql(), resultSet -> {
                ArrayList<PprofTaskLog> tasks = new ArrayList<PprofTaskLog>();
                while (resultSet.next()) {
                    tasks.add(this.parseLog(resultSet));
                }
                return tasks;
            }, sqlAndParameters.parameters());
            results.addAll(logs);
        }
        return results;
    }

    private SQLAndParameters buildSQL(String table) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>(2);
        sql.append("select * from ").append(table).append(" where ").append("table_name").append(" = ?");
        parameters.add("pprof_task_log");
        sql.append(" order by ").append("operation_time").append(" desc");
        return new SQLAndParameters(sql.toString(), parameters);
    }

    private PprofTaskLog parseLog(ResultSet data) throws SQLException {
        return PprofTaskLog.builder().id(data.getString("task_id")).instanceId(data.getString("instance_id")).operationType(PprofTaskLogOperationType.parse((int)data.getInt("operation_type"))).operationTime(data.getLong("operation_time")).build();
    }

    @Generated
    public JDBCPprofTaskLogQueryDAO(JDBCClient jdbcClient, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
    }
}

