/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.jdkhttp;

import io.fabric8.kubernetes.client.http.BufferUtil;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JdkWebSocketImpl
implements io.fabric8.kubernetes.client.http.WebSocket,
WebSocket.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(JdkWebSocketImpl.class);
    private volatile WebSocket webSocket;
    private final AtomicLong queueSize = new AtomicLong();
    private final WebSocket.Listener listener;
    private final StringBuilder stringBuilder = new StringBuilder();
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private final WritableByteChannel byteChannel = Channels.newChannel(this.byteArrayOutputStream);
    private final CompletableFuture<Void> terminated = new CompletableFuture();

    public JdkWebSocketImpl(WebSocket.Listener listener) {
        this.listener = listener;
    }

    @Override
    public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
        try {
            this.byteChannel.write(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (last) {
            ByteBuffer value = ByteBuffer.wrap(this.byteArrayOutputStream.toByteArray());
            this.byteArrayOutputStream.reset();
            this.listener.onMessage((io.fabric8.kubernetes.client.http.WebSocket)this, value);
        } else {
            webSocket.request(1L);
        }
        return null;
    }

    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
        this.stringBuilder.append(data);
        if (last) {
            String value = this.stringBuilder.toString();
            this.stringBuilder.setLength(0);
            this.listener.onMessage((io.fabric8.kubernetes.client.http.WebSocket)this, value);
        } else {
            webSocket.request(1L);
        }
        return null;
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        this.terminated.complete(null);
        this.listener.onClose((io.fabric8.kubernetes.client.http.WebSocket)this, statusCode, reason);
        return null;
    }

    @Override
    public void onError(WebSocket webSocket, Throwable error) {
        this.terminated.complete(null);
        this.listener.onError((io.fabric8.kubernetes.client.http.WebSocket)this, error);
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        this.webSocket = webSocket;
        webSocket.request(1L);
        this.listener.onOpen((io.fabric8.kubernetes.client.http.WebSocket)this);
    }

    public boolean send(ByteBuffer buffer) {
        buffer = BufferUtil.copy((ByteBuffer)buffer);
        int size = buffer.remaining();
        this.queueSize.addAndGet(size);
        CompletableFuture<WebSocket> cf = this.webSocket.sendBinary(buffer, true);
        if (cf.isDone()) {
            this.queueSize.addAndGet(-size);
            return !cf.isCompletedExceptionally();
        }
        cf.whenComplete((b, t) -> {
            if (t != null) {
                LOG.warn("Queued write did not succeed", t);
                this.abort();
            }
            this.queueSize.addAndGet(-size);
        });
        return true;
    }

    public synchronized boolean sendClose(int code, String reason) {
        if (this.webSocket.isOutputClosed()) {
            return false;
        }
        CompletionStage<WebSocket> cf = this.webSocket.sendClose(code, reason == null ? "Closing" : reason);
        cf = ((CompletableFuture)cf).whenComplete((w, t) -> {
            if (t != null) {
                this.abort();
            } else if (w != null) {
                this.webSocket.request(1L);
                CompletableFuture future = Utils.schedule(Runnable::run, this::abort, (long)1L, (TimeUnit)TimeUnit.MINUTES);
                this.terminated.whenComplete((v, ignored) -> future.cancel(true));
            }
        });
        return !((CompletableFuture)cf).isCompletedExceptionally();
    }

    private void abort() {
        if (!this.webSocket.isOutputClosed() || !this.webSocket.isInputClosed()) {
            LOG.warn("Aborting WebSocket due to a write error or failure with sendClose");
            this.webSocket.abort();
            if (this.terminated.complete(null)) {
                this.listener.onClose((io.fabric8.kubernetes.client.http.WebSocket)this, 1006, "Aborted the WebSocket");
            }
        }
    }

    public long queueSize() {
        return this.queueSize.get();
    }

    public void request() {
        this.webSocket.request(1L);
    }
}

