/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.skywalking.mqe.rt.exception.ParseErrorListener;
import org.apache.skywalking.mqe.rt.grammar.MQELexer;
import org.apache.skywalking.mqe.rt.grammar.MQEParser;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.MetaInAlarm;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmEntity;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmMessageFormatter;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRule;
import org.apache.skywalking.oap.server.core.alarm.provider.expr.rt.AlarmMQEVisitor;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.analysis.metrics.DoubleValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.LabeledValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.LongValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResult;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResultType;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValue;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValues;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.joda.time.LocalDateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunningRule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RunningRule.class);
    private static DateTimeFormatter TIME_BUCKET_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMMddHHmm");
    private final String ruleName;
    private final int period;
    private final String expression;
    private final int silencePeriod;
    private final Map<AlarmEntity, Window> windows;
    private final List<String> includeNames;
    private final List<String> excludeNames;
    private final Pattern includeNamesRegex;
    private final Pattern excludeNamesRegex;
    private final AlarmMessageFormatter formatter;
    private final List<Tag> tags;
    private final Set<String> hooks;
    private final Set<String> includeMetrics;
    private final ParseTree exprTree;
    private final int additionalPeriod;
    private final ModuleManager moduleManager;

    public RunningRule(AlarmRule alarmRule, ModuleManager moduleManager) {
        this.expression = alarmRule.getExpression();
        this.ruleName = alarmRule.getAlarmRuleName();
        this.includeMetrics = alarmRule.getIncludeMetrics();
        this.windows = new ConcurrentHashMap<AlarmEntity, Window>();
        this.period = alarmRule.getPeriod();
        this.silencePeriod = alarmRule.getSilencePeriod();
        this.includeNames = alarmRule.getIncludeNames();
        this.excludeNames = alarmRule.getExcludeNames();
        this.includeNamesRegex = StringUtil.isNotEmpty((String)alarmRule.getIncludeNamesRegex()) ? Pattern.compile(alarmRule.getIncludeNamesRegex()) : null;
        this.excludeNamesRegex = StringUtil.isNotEmpty((String)alarmRule.getExcludeNamesRegex()) ? Pattern.compile(alarmRule.getExcludeNamesRegex()) : null;
        this.formatter = new AlarmMessageFormatter(alarmRule.getMessage());
        this.tags = alarmRule.getTags().entrySet().stream().map(e -> new Tag((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        this.hooks = alarmRule.getHooks();
        MQELexer lexer = new MQELexer((CharStream)CharStreams.fromString((String)alarmRule.getExpression()));
        MQEParser parser = new MQEParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        this.exprTree = parser.expression();
        this.additionalPeriod = alarmRule.getMaxTrendRange();
        this.moduleManager = moduleManager;
    }

    public void in(MetaInAlarm meta, Metrics metrics) {
        if (!this.includeMetrics.contains(meta.getMetricsName())) {
            if (log.isTraceEnabled()) {
                log.trace("Metric name not in the expression, {}-{}", (Object)this.expression, (Object)meta.getMetricsName());
            }
            return;
        }
        String metaName = meta.getName();
        if (!this.validate(metaName, this.includeNames, this.excludeNames, this.includeNamesRegex, this.excludeNamesRegex)) {
            return;
        }
        AlarmEntity entity = new AlarmEntity(meta.getScope(), meta.getScopeId(), meta.getName(), meta.getId0(), meta.getId1());
        Window window = this.windows.computeIfAbsent(entity, ignored -> new Window(entity, this.period, this.additionalPeriod));
        window.add(meta.getMetricsName(), metrics);
    }

    private boolean validate(String target, List<String> includeList, List<String> excludeList, Pattern includeRegex, Pattern excludeRegex) {
        if (CollectionUtils.isNotEmpty(includeList) && !includeList.contains(target)) {
            if (log.isTraceEnabled()) {
                log.trace("{} isn't in the including list {}", (Object)target, includeList);
            }
            return false;
        }
        if (CollectionUtils.isNotEmpty(excludeList) && excludeList.contains(target)) {
            if (log.isTraceEnabled()) {
                log.trace("{} is in the excluding list {}", (Object)target, excludeList);
            }
            return false;
        }
        if (includeRegex != null && !includeRegex.matcher(target).matches()) {
            if (log.isTraceEnabled()) {
                log.trace("{} doesn't match the include regex {}", (Object)target, (Object)includeRegex);
            }
            return false;
        }
        if (excludeRegex != null && excludeRegex.matcher(target).matches()) {
            if (log.isTraceEnabled()) {
                log.trace("{} matches the exclude regex {}", (Object)target, (Object)excludeRegex);
            }
            return false;
        }
        return true;
    }

    public void moveTo(LocalDateTime targetTime) {
        LocalDateTime target = targetTime.withSecondOfMinute(0).withMillisOfSecond(0);
        this.windows.values().forEach(window -> window.moveTo(target));
    }

    public List<AlarmMessage> check() {
        ArrayList<AlarmMessage> alarmMessageList = new ArrayList<AlarmMessage>(30);
        ArrayList expiredEntityList = new ArrayList();
        this.windows.forEach((alarmEntity, window) -> {
            if (window.isExpired()) {
                expiredEntityList.add(alarmEntity);
                return;
            }
            Optional<AlarmMessage> alarmMessageOptional = window.checkAlarm();
            if (alarmMessageOptional.isPresent()) {
                AlarmMessage alarmMessage = alarmMessageOptional.get();
                alarmMessage.setScopeId(alarmEntity.getScopeId());
                alarmMessage.setScope(alarmEntity.getScope());
                alarmMessage.setName(alarmEntity.getName());
                alarmMessage.setId0(alarmEntity.getId0());
                alarmMessage.setId1(alarmEntity.getId1());
                alarmMessage.setRuleName(this.ruleName);
                alarmMessage.setAlarmMessage(this.formatter.format((AlarmEntity)alarmEntity));
                alarmMessage.setStartTime(System.currentTimeMillis());
                alarmMessage.setPeriod(this.period);
                alarmMessage.setTags(this.tags);
                alarmMessage.setHooks(this.hooks);
                alarmMessage.setExpression(this.expression);
                alarmMessage.setMqeMetricsSnapshot(window.mqeMetricsSnapshot);
                alarmMessageList.add(alarmMessage);
            }
        });
        expiredEntityList.forEach(this.windows::remove);
        return alarmMessageList;
    }

    private LinkedList<Map<String, TraceLogMetric>> transformValues(LinkedList<Map<String, Metrics>> values) {
        LinkedList<Map<String, TraceLogMetric>> result = new LinkedList<Map<String, TraceLogMetric>>();
        for (Map map : values) {
            if (map == null) {
                result.add(null);
                continue;
            }
            map.forEach((name, m) -> {
                HashMap<String, TraceLogMetric> r = new HashMap<String, TraceLogMetric>();
                result.add(r);
                if (m instanceof LongValueHolder) {
                    r.put((String)name, new TraceLogMetric(m.getTimeBucket(), new Number[]{((LongValueHolder)m).getValue()}));
                } else if (m instanceof IntValueHolder) {
                    r.put((String)name, new TraceLogMetric(m.getTimeBucket(), new Number[]{((IntValueHolder)m).getValue()}));
                } else if (m instanceof DoubleValueHolder) {
                    r.put((String)name, new TraceLogMetric(m.getTimeBucket(), new Number[]{((DoubleValueHolder)m).getValue()}));
                } else if (m instanceof LabeledValueHolder) {
                    DataTable dt = ((LabeledValueHolder)m).getValue();
                    TraceLogMetric l = new TraceLogMetric(m.getTimeBucket(), dt.sortedValues(Comparator.naturalOrder()).toArray(new Number[0]));
                    l.labels = dt.sortedKeys(Comparator.naturalOrder()).toArray(new String[0]);
                    r.put((String)name, l);
                } else {
                    log.warn("Unsupported metrics {}", m);
                }
            });
        }
        return result;
    }

    @Generated
    public String getRuleName() {
        return this.ruleName;
    }

    @Generated
    public int getPeriod() {
        return this.period;
    }

    @Generated
    public String getExpression() {
        return this.expression;
    }

    @Generated
    public int getSilencePeriod() {
        return this.silencePeriod;
    }

    @Generated
    public Map<AlarmEntity, Window> getWindows() {
        return this.windows;
    }

    @Generated
    public List<String> getIncludeNames() {
        return this.includeNames;
    }

    @Generated
    public List<String> getExcludeNames() {
        return this.excludeNames;
    }

    @Generated
    public Pattern getIncludeNamesRegex() {
        return this.includeNamesRegex;
    }

    @Generated
    public Pattern getExcludeNamesRegex() {
        return this.excludeNamesRegex;
    }

    @Generated
    public AlarmMessageFormatter getFormatter() {
        return this.formatter;
    }

    @Generated
    public List<Tag> getTags() {
        return this.tags;
    }

    @Generated
    public Set<String> getHooks() {
        return this.hooks;
    }

    @Generated
    public Set<String> getIncludeMetrics() {
        return this.includeMetrics;
    }

    @Generated
    public ParseTree getExprTree() {
        return this.exprTree;
    }

    @Generated
    public int getAdditionalPeriod() {
        return this.additionalPeriod;
    }

    @Generated
    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    public class Window {
        private LocalDateTime endTime;
        private final int additionalPeriod;
        private final int size;
        private int silenceCountdown;
        private LinkedList<Map<String, Metrics>> values;
        private ReentrantLock lock = new ReentrantLock();
        private JsonObject mqeMetricsSnapshot;
        private AlarmEntity entity;

        public Window(AlarmEntity entity, int period, int additionalPeriod) {
            this.entity = entity;
            this.additionalPeriod = additionalPeriod;
            this.size = period + additionalPeriod;
            this.silenceCountdown = -1;
            this.init();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void moveTo(LocalDateTime current) {
            this.lock.lock();
            try {
                if (this.endTime == null) {
                    this.init();
                } else {
                    int minutes = Minutes.minutesBetween((ReadablePartial)this.endTime, (ReadablePartial)current).getMinutes();
                    if (minutes <= 0) {
                        return;
                    }
                    if (minutes > this.values.size()) {
                        this.init();
                    } else {
                        for (int i = 0; i < minutes; ++i) {
                            this.values.removeFirst();
                            this.values.addLast(null);
                        }
                    }
                }
                this.endTime = current;
            }
            finally {
                this.lock.unlock();
            }
            if (log.isTraceEnabled()) {
                log.trace("Move window {}", RunningRule.this.transformValues(this.values));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(String metricsName, Metrics metrics) {
            long bucket = metrics.getTimeBucket();
            LocalDateTime timeBucket = TIME_BUCKET_FORMATTER.parseLocalDateTime("" + bucket);
            this.lock.lock();
            try {
                int minutes;
                if (this.endTime == null) {
                    this.init();
                    this.endTime = timeBucket;
                }
                if ((minutes = Minutes.minutesBetween((ReadablePartial)timeBucket, (ReadablePartial)this.endTime).getMinutes()) < 0) {
                    this.moveTo(timeBucket);
                    minutes = 0;
                }
                if (minutes >= this.values.size()) {
                    if (log.isTraceEnabled()) {
                        log.trace("Timebucket is {}, endTime is {} and value size is {}", new Object[]{timeBucket, this.endTime, this.values.size()});
                    }
                    return;
                }
                int index = this.values.size() - minutes - 1;
                Map<String, Metrics> metricsMap = this.values.get(index);
                if (metricsMap == null) {
                    metricsMap = new HashMap<String, Metrics>();
                    metricsMap.put(metricsName, metrics);
                    this.values.set(index, metricsMap);
                } else {
                    metricsMap.put(metricsName, metrics);
                }
            }
            finally {
                this.lock.unlock();
            }
            if (log.isTraceEnabled()) {
                log.trace("Add metric {} to window {}", (Object)metrics, RunningRule.this.transformValues(this.values));
            }
        }

        public Optional<AlarmMessage> checkAlarm() {
            if (this.isMatch()) {
                if (this.silenceCountdown < 1) {
                    this.silenceCountdown = RunningRule.this.silencePeriod;
                    return Optional.of(new AlarmMessage());
                }
                --this.silenceCountdown;
            } else {
                --this.silenceCountdown;
            }
            return Optional.empty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isMatch() {
            this.lock.lock();
            int isMatch = 0;
            try {
                DebuggingTraceContext.TRACE_CONTEXT.set(new DebuggingTraceContext(RunningRule.this.expression, false, false));
                AlarmMQEVisitor visitor = new AlarmMQEVisitor(RunningRule.this.moduleManager, this.entity, this.values, this.endTime, this.additionalPeriod);
                ExpressionResult parseResult = (ExpressionResult)visitor.visit(RunningRule.this.exprTree);
                if (StringUtil.isNotBlank((String)parseResult.getError())) {
                    log.error("expression:" + RunningRule.this.expression + " error: " + parseResult.getError());
                    boolean bl = false;
                    return bl;
                }
                if (!parseResult.isBoolResult() || ExpressionResultType.SINGLE_VALUE != parseResult.getType() || CollectionUtils.isEmpty((List)parseResult.getResults())) {
                    boolean bl = false;
                    return bl;
                }
                if (!parseResult.isLabeledResult()) {
                    MQEValues mqeValues = (MQEValues)parseResult.getResults().get(0);
                    if (mqeValues != null && CollectionUtils.isNotEmpty((List)mqeValues.getValues()) && mqeValues.getValues().get(0) != null) {
                        isMatch = (int)((MQEValue)mqeValues.getValues().get(0)).getDoubleValue();
                    }
                } else {
                    MQEValues mqeValues;
                    Iterator iterator = parseResult.getResults().iterator();
                    while (iterator.hasNext() && ((mqeValues = (MQEValues)iterator.next()) == null || !CollectionUtils.isNotEmpty((List)mqeValues.getValues()) || mqeValues.getValues().get(0) == null || (isMatch = (int)((MQEValue)mqeValues.getValues().get(0)).getDoubleValue()) != 1)) {
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace("Match expression is {}", (Object)RunningRule.this.expression);
                }
                this.mqeMetricsSnapshot = visitor.getMqeMetricsSnapshot();
                boolean bl = isMatch == 1;
                return bl;
            }
            finally {
                this.lock.unlock();
                DebuggingTraceContext.TRACE_CONTEXT.remove();
            }
        }

        public boolean isExpired() {
            if (this.values != null) {
                for (Map map : this.values) {
                    if (map == null) continue;
                    return false;
                }
            }
            return true;
        }

        public void scanWindowValues(Consumer<LinkedList<Map<String, Metrics>>> scanFunction) {
            this.lock.lock();
            try {
                scanFunction.accept(this.values);
            }
            finally {
                this.lock.unlock();
            }
        }

        private void init() {
            this.values = new LinkedList();
            for (int i = 0; i < this.size; ++i) {
                this.values.add(null);
            }
        }

        @Generated
        public LocalDateTime getEndTime() {
            return this.endTime;
        }

        @Generated
        public int getAdditionalPeriod() {
            return this.additionalPeriod;
        }

        @Generated
        public int getSize() {
            return this.size;
        }

        @Generated
        public int getSilenceCountdown() {
            return this.silenceCountdown;
        }

        @Generated
        public JsonObject getMqeMetricsSnapshot() {
            return this.mqeMetricsSnapshot;
        }
    }

    private static class TraceLogMetric {
        private final long timeBucket;
        private final Number[] value;
        private String[] labels;

        @Generated
        public TraceLogMetric(long timeBucket, Number[] value) {
            this.timeBucket = timeBucket;
            this.value = value;
        }

        @Generated
        public String toString() {
            return "RunningRule.TraceLogMetric(timeBucket=" + this.timeBucket + ", value=" + Arrays.deepToString(this.value) + ", labels=" + Arrays.deepToString(this.labels) + ")";
        }
    }
}

