/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.skywalking.oap.server.core.analysis;

import org.apache.skywalking.oap.server.core.source.ISource;

/**
 * SourceDispatcher implementation processes different types of the source. There are two kinds of the source
 * dispatcher. All implementations are doing field values set/get to transfer the data to the streaming process.
 *
 * One is hard coded, which could be found through the hierarchy tree. The other is generated by OAL engine based on the
 * templates insides oal-rt/src/main/resources/code-templates/dispatcher
 *
 * @param <SOURCE> the data type of this dispatcher processes.
 */
public interface SourceDispatcher<SOURCE extends ISource> {
    void dispatch(SOURCE source);
}
