/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.elasticsearch.v6.interceptor;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.elasticsearch.v6.ElasticsearchPluginConfig;
import org.apache.skywalking.apm.plugin.elasticsearch.v6.TransportClientEnhanceInfo;
import org.apache.skywalking.apm.plugin.elasticsearch.v6.interceptor.Constants;
import org.apache.skywalking.apm.util.StringUtil;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.cluster.node.DiscoveryNode;

public class TransportActionNodeProxyExecuteMethodsInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        TransportClientEnhanceInfo enhanceInfo = (TransportClientEnhanceInfo)objInst.getSkyWalkingDynamicField();
        ActionRequest request = (ActionRequest)allArguments[1];
        String opType = request.getClass().getSimpleName();
        String operationName = "Elasticsearch/" + opType;
        AbstractSpan span = ContextManager.createExitSpan((String)operationName, (String)enhanceInfo.transportAddresses());
        span.setComponent((Component)ComponentsDefine.TRANSPORT_CLIENT);
        Tags.DB_TYPE.set(span, "Elasticsearch");
        Tags.DB_INSTANCE.set(span, enhanceInfo.getClusterName());
        span.tag(Constants.ES_NODE, ((DiscoveryNode)allArguments[0]).getAddress().toString());
        this.parseRequestInfo(request, span);
        SpanLayer.asDB((AbstractSpan)span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }

    private void parseRequestInfo(ActionRequest request, AbstractSpan span) {
        if (request instanceof SearchRequest) {
            this.parseSearchRequest((SearchRequest)request, span);
            return;
        }
        if (request instanceof GetRequest) {
            this.parseGetRequest((GetRequest)request, span);
            return;
        }
        if (request instanceof IndexRequest) {
            this.parseIndexRequest((IndexRequest)request, span);
            return;
        }
        if (request instanceof UpdateRequest) {
            this.parseUpdateRequest((UpdateRequest)request, span);
            return;
        }
        if (request instanceof DeleteRequest) {
            this.parseDeleteRequest((DeleteRequest)request, span);
            return;
        }
        if (request instanceof DeleteIndexRequest) {
            this.parseDeleteIndexRequest((DeleteIndexRequest)request, span);
            return;
        }
    }

    private void parseSearchRequest(SearchRequest searchRequest, AbstractSpan span) {
        span.tag(Constants.ES_INDEX, StringUtil.join((char)',', (String[])searchRequest.indices()));
        span.tag(Constants.ES_TYPE, StringUtil.join((char)',', (String[])searchRequest.types()));
        if (ElasticsearchPluginConfig.Plugin.Elasticsearch.TRACE_DSL) {
            Tags.DB_STATEMENT.set(span, searchRequest.toString());
        }
    }

    private void parseGetRequest(GetRequest getRequest, AbstractSpan span) {
        span.tag(Constants.ES_INDEX, getRequest.index());
        span.tag(Constants.ES_TYPE, getRequest.type());
        if (ElasticsearchPluginConfig.Plugin.Elasticsearch.TRACE_DSL) {
            Tags.DB_STATEMENT.set(span, getRequest.toString());
        }
    }

    private void parseIndexRequest(IndexRequest indexRequest, AbstractSpan span) {
        span.tag(Constants.ES_INDEX, indexRequest.index());
        span.tag(Constants.ES_TYPE, indexRequest.type());
        if (ElasticsearchPluginConfig.Plugin.Elasticsearch.TRACE_DSL) {
            Tags.DB_STATEMENT.set(span, indexRequest.toString());
        }
    }

    private void parseUpdateRequest(UpdateRequest updateRequest, AbstractSpan span) {
        span.tag(Constants.ES_INDEX, updateRequest.index());
        span.tag(Constants.ES_TYPE, updateRequest.type());
        if (ElasticsearchPluginConfig.Plugin.Elasticsearch.TRACE_DSL) {
            Tags.DB_STATEMENT.set(span, updateRequest.toString());
        }
    }

    private void parseDeleteRequest(DeleteRequest deleteRequest, AbstractSpan span) {
        span.tag(Constants.ES_INDEX, deleteRequest.index());
        span.tag(Constants.ES_TYPE, deleteRequest.type());
        if (ElasticsearchPluginConfig.Plugin.Elasticsearch.TRACE_DSL) {
            Tags.DB_STATEMENT.set(span, deleteRequest.toString());
        }
    }

    private void parseDeleteIndexRequest(DeleteIndexRequest deleteIndexRequest, AbstractSpan span) {
        span.tag(Constants.ES_INDEX, String.join((CharSequence)",", deleteIndexRequest.indices()));
    }
}

