/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.jcr.NamespaceException;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.vault.fs.io.DocViewParser;
import org.apache.jackrabbit.vault.fs.io.DocViewParserHandler;
import org.apache.jackrabbit.vault.validation.ValidationViolation;
import org.apache.jackrabbit.vault.validation.impl.util.EnhancedBufferedInputStream;
import org.apache.jackrabbit.vault.validation.impl.util.ValidatorDocViewParserHandler;
import org.apache.jackrabbit.vault.validation.spi.DocumentViewXmlValidator;
import org.apache.jackrabbit.vault.validation.spi.GenericJcrDataValidator;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.InputSource;

public class DocumentViewParserValidator
implements GenericJcrDataValidator {
    public static final String EXTENDED_FILE_AGGREGATE_FOLDER_SUFFIX = ".dir";
    private final Map<String, DocumentViewXmlValidator> docViewValidators = new HashMap<String, DocumentViewXmlValidator>();
    private final DocViewParser docViewParser;
    @NotNull
    private final ValidationMessageSeverity severity;

    public DocumentViewParserValidator(@NotNull ValidationMessageSeverity severity, boolean allowUndeclaredPrefixInFileName) {
        if (allowUndeclaredPrefixInFileName) {
            NamespaceResolver nsResolver = new NamespaceResolver(){

                public String getURI(String prefix) throws NamespaceException {
                    return "http://undeclared.uri";
                }

                public String getPrefix(String uri) throws NamespaceException {
                    return "undeclared prefix";
                }
            };
            this.docViewParser = new DocViewParser(nsResolver);
        } else {
            this.docViewParser = new DocViewParser();
        }
        this.severity = severity;
    }

    public void setDocumentViewXmlValidators(Map<String, DocumentViewXmlValidator> documentViewXmlValidators) {
        this.docViewValidators.putAll(documentViewXmlValidators);
    }

    @Override
    public Collection<ValidationMessage> done() {
        return null;
    }

    @Override
    public boolean shouldValidateJcrData(@NotNull Path filePath, @NotNull Path basePath) {
        return filePath.toString().endsWith(".xml");
    }

    @Override
    public Collection<ValidationMessage> validateJcrData(@NotNull InputStream input, @NotNull Path filePath, @NotNull Path basePath, @NotNull Map<String, Integer> nodePathsAndLineNumbers) throws IOException {
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        EnhancedBufferedInputStream bufferedInput = new EnhancedBufferedInputStream(input);
        String documentViewXmlRootNodePath = DocViewParser.getDocumentViewXmlRootNodePath((InputStream)bufferedInput, (Path)filePath);
        if (documentViewXmlRootNodePath != null) {
            messages.addAll(this.validateDocumentViewXml(bufferedInput, filePath, basePath, documentViewXmlRootNodePath, nodePathsAndLineNumbers));
        } else {
            messages.add(new ValidationMessage(ValidationMessageSeverity.INFO, "This file is not detected as docview xml file and therefore treated as binary"));
        }
        return messages;
    }

    protected Collection<ValidationMessage> validateDocumentViewXml(InputStream input, @NotNull Path filePath, @NotNull Path basePath, String rootNodePath, Map<String, Integer> nodePathsAndLineNumbers) throws IOException {
        LinkedList<ValidationMessage> enrichedMessages = new LinkedList<ValidationMessage>();
        enrichedMessages.add(new ValidationMessage(ValidationMessageSeverity.DEBUG, "Detected DocView..."));
        ValidatorDocViewParserHandler handler = new ValidatorDocViewParserHandler(this.severity, this.docViewValidators, filePath, basePath);
        try {
            this.docViewParser.parse(rootNodePath, new InputSource((InputStream)new CloseShieldInputStream(input)), (DocViewParserHandler)handler);
            enrichedMessages.addAll(ValidationViolation.wrapMessages(null, handler.getViolations(), filePath, basePath, rootNodePath, 0, 0));
        }
        catch (DocViewParser.XmlParseException e) {
            enrichedMessages.add(new ValidationViolation("jackrabbit-docviewparser", this.severity, "Could not parse FileVault Document View XML: " + e.getMessage(), filePath, basePath, e.getNodePath(), e.getLineNumber(), e.getColumnNumber(), e));
        }
        nodePathsAndLineNumbers.putAll(handler.getNodePaths());
        return enrichedMessages;
    }
}

