/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.multilang;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.storm.multilang.BoltMsg;
import org.apache.storm.multilang.ISerializer;
import org.apache.storm.multilang.NoOutputException;
import org.apache.storm.multilang.ShellMsg;
import org.apache.storm.multilang.SpoutMsg;
import org.apache.storm.shade.net.minidev.json.JSONObject;
import org.apache.storm.shade.net.minidev.json.JSONValue;
import org.apache.storm.shade.net.minidev.json.parser.ParseException;
import org.apache.storm.task.TopologyContext;

public class JsonSerializer
implements ISerializer {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final long serialVersionUID = 2548814660410474022L;
    private transient BufferedWriter processIn;
    private transient BufferedReader processOut;

    @Override
    public void initialize(OutputStream processIn, InputStream processOut) {
        try {
            this.processIn = new BufferedWriter(new OutputStreamWriter(processIn, DEFAULT_CHARSET));
            this.processOut = new BufferedReader(new InputStreamReader(processOut, DEFAULT_CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Number connect(Map<String, Object> conf, TopologyContext context) throws IOException, NoOutputException {
        JSONObject setupInfo = new JSONObject();
        setupInfo.put((Object)"pidDir", (Object)context.getPIDDir());
        setupInfo.put((Object)"conf", conf);
        setupInfo.put((Object)"context", (Object)context);
        this.writeMessage(setupInfo);
        Number pid = (Number)((JSONObject)this.readMessage()).get((Object)"pid");
        return pid;
    }

    @Override
    public void writeBoltMsg(BoltMsg boltMsg) throws IOException {
        JSONObject obj = new JSONObject();
        obj.put((Object)"id", (Object)boltMsg.getId());
        obj.put((Object)"comp", (Object)boltMsg.getComp());
        obj.put((Object)"stream", (Object)boltMsg.getStream());
        obj.put((Object)"task", (Object)boltMsg.getTask());
        obj.put((Object)"tuple", boltMsg.getTuple());
        this.writeMessage(obj);
    }

    @Override
    public void writeSpoutMsg(SpoutMsg msg) throws IOException {
        JSONObject obj = new JSONObject();
        obj.put((Object)"command", (Object)msg.getCommand());
        obj.put((Object)"id", msg.getId());
        this.writeMessage(obj);
    }

    @Override
    public void writeTaskIds(List<Integer> taskIds) throws IOException {
        this.writeMessage(taskIds);
    }

    private void writeMessage(Object msg) throws IOException {
        this.writeString(JSONValue.toJSONString((Object)msg));
    }

    private void writeString(String str) throws IOException {
        this.processIn.write(str);
        this.processIn.write("\nend\n");
        this.processIn.flush();
    }

    @Override
    public ShellMsg readShellMsg() throws IOException, NoOutputException {
        Object logLevelObj;
        JSONObject msg = (JSONObject)this.readMessage();
        ShellMsg shellMsg = new ShellMsg();
        String command = (String)msg.get((Object)"command");
        shellMsg.setCommand(command);
        Object id = msg.get((Object)"id");
        shellMsg.setId(id);
        String log = (String)msg.get((Object)"msg");
        shellMsg.setMsg(log);
        String stream = (String)msg.get((Object)"stream");
        if (stream == null) {
            stream = "default";
        }
        shellMsg.setStream(stream);
        Object taskObj = msg.get((Object)"task");
        if (taskObj != null) {
            shellMsg.setTask((Long)taskObj);
        } else {
            shellMsg.setTask(0L);
        }
        Object needTaskIds = msg.get((Object)"need_task_ids");
        if (needTaskIds == null || ((Boolean)needTaskIds).booleanValue()) {
            shellMsg.setNeedTaskIds(true);
        } else {
            shellMsg.setNeedTaskIds(false);
        }
        shellMsg.setTuple((List)msg.get((Object)"tuple"));
        List<Object> anchorObj = msg.get((Object)"anchors");
        if (anchorObj != null) {
            if (anchorObj instanceof String) {
                anchorObj = Arrays.asList(anchorObj);
            }
            for (Object o : (List)anchorObj) {
                shellMsg.addAnchor((String)o);
            }
        }
        Object nameObj = msg.get((Object)"name");
        String metricName = null;
        if (nameObj != null && nameObj instanceof String) {
            metricName = (String)nameObj;
        }
        shellMsg.setMetricName(metricName);
        Object paramsObj = msg.get((Object)"params");
        shellMsg.setMetricParams(paramsObj);
        if (command.equals("log") && (logLevelObj = msg.get((Object)"level")) != null && logLevelObj instanceof Number) {
            int logLevel = ((Number)logLevelObj).intValue();
            shellMsg.setLogLevel(logLevel);
        }
        return shellMsg;
    }

    private Object readMessage() throws IOException, NoOutputException {
        try {
            return JSONValue.parseWithException((String)this.readString());
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    private String readString() throws IOException, NoOutputException {
        StringBuilder line = new StringBuilder();
        while (true) {
            String subline;
            if ((subline = this.processOut.readLine()) == null) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append("Pipe to subprocess seems to be broken!");
                if (line.length() == 0) {
                    errorMessage.append(" No output read.\n");
                } else {
                    errorMessage.append(" Currently read output: " + line.toString() + "\n");
                }
                errorMessage.append("Serializer Exception:\n");
                throw new NoOutputException(errorMessage.toString());
            }
            if (subline.equals("end")) break;
            if (line.length() != 0) {
                line.append("\n");
            }
            line.append(subline);
        }
        return line.toString();
    }
}

