/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.networktopography;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.storm.networktopography.AbstractDNSToSwitchMapping;

public final class DefaultRackDNSToSwitchMapping
extends AbstractDNSToSwitchMapping {
    private Map<String, String> mappingCache = new ConcurrentHashMap<String, String>();

    @Override
    public Map<String, String> resolve(List<String> names) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (names.isEmpty()) {
            return m;
        }
        for (String name : names) {
            m.put(name, "/default-rack");
            this.mappingCache.put(name, "/default-rack");
        }
        return m;
    }

    public String toString() {
        return "DefaultRackDNSToSwitchMapping (" + this.mappingCache.size() + " mappings cached)" + this.dumpTopology();
    }
}

