/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.planner.processor;

import java.util.List;
import java.util.Map;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.trident.operation.Function;
import org.apache.storm.trident.operation.TridentOperationContext;
import org.apache.storm.trident.planner.ProcessorContext;
import org.apache.storm.trident.planner.TridentProcessor;
import org.apache.storm.trident.planner.processor.FreshCollector;
import org.apache.storm.trident.planner.processor.TridentContext;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;
import org.apache.storm.tuple.Fields;

public class MapProcessor
implements TridentProcessor {
    Function function;
    TridentContext context;
    FreshCollector collector;
    Fields inputFields;
    TridentTupleView.ProjectionFactory projection;

    public MapProcessor(Fields inputFields, Function function) {
        this.function = function;
        this.inputFields = inputFields;
    }

    @Override
    public void prepare(Map<String, Object> conf, TopologyContext context, TridentContext tridentContext) {
        List<TridentTuple.Factory> parents = tridentContext.getParentTupleFactories();
        if (parents.size() != 1) {
            throw new RuntimeException("Map operation can only have one parent");
        }
        this.context = tridentContext;
        this.collector = new FreshCollector(tridentContext);
        this.projection = new TridentTupleView.ProjectionFactory(parents.get(0), this.inputFields);
        this.function.prepare(conf, new TridentOperationContext(context, (TridentTuple.Factory)this.projection));
    }

    @Override
    public void cleanup() {
        this.function.cleanup();
    }

    @Override
    public void execute(ProcessorContext processorContext, String streamId, TridentTuple tuple) {
        this.collector.setContext(processorContext);
        this.function.execute(this.projection.create(tuple), this.collector);
    }

    @Override
    public void flush() {
        this.collector.flush();
    }

    @Override
    public void startBatch(ProcessorContext processorContext) {
    }

    @Override
    public void finishBatch(ProcessorContext processorContext) {
    }

    @Override
    public TridentTuple.Factory getOutputFactory() {
        return this.collector.getOutputFactory();
    }
}

