/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.uk.org.lidalia.sysoutslf4j.system;

import java.io.PrintStream;
import org.apache.storm.shade.uk.org.lidalia.sysoutslf4j.common.PrintStreamCoordinator;
import org.apache.storm.shade.uk.org.lidalia.sysoutslf4j.common.SLF4JPrintStream;
import org.apache.storm.shade.uk.org.lidalia.sysoutslf4j.common.SystemOutput;
import org.apache.storm.shade.uk.org.lidalia.sysoutslf4j.system.LoggerAppenderStore;
import org.apache.storm.shade.uk.org.lidalia.sysoutslf4j.system.SLF4JPrintStreamDelegate;
import org.apache.storm.shade.uk.org.lidalia.sysoutslf4j.system.SLF4JPrintStreamImpl;

public final class PrintStreamCoordinatorImpl
implements PrintStreamCoordinator {
    @Override
    public void replaceSystemOutputsWithSLF4JPrintStreams() {
        SystemOutput[] systemOutputArray = SystemOutput.values();
        int n = systemOutputArray.length;
        int n2 = 0;
        while (n2 < n) {
            SystemOutput systemOutput = systemOutputArray[n2];
            PrintStreamCoordinatorImpl.replaceSystemOutputWithSLF4JPrintStream(systemOutput);
            ++n2;
        }
    }

    private static void replaceSystemOutputWithSLF4JPrintStream(SystemOutput systemOutput) {
        SLF4JPrintStreamImpl slf4jPrintStream = PrintStreamCoordinatorImpl.buildSLF4JPrintStream(systemOutput.get());
        systemOutput.set(slf4jPrintStream);
    }

    private static SLF4JPrintStreamImpl buildSLF4JPrintStream(PrintStream originalPrintStream) {
        LoggerAppenderStore loggerAppenderStore = new LoggerAppenderStore();
        SLF4JPrintStreamDelegate delegate = new SLF4JPrintStreamDelegate(originalPrintStream, loggerAppenderStore);
        return new SLF4JPrintStreamImpl(originalPrintStream, delegate);
    }

    @Override
    public void restoreOriginalSystemOutputs() {
        SystemOutput[] systemOutputArray = SystemOutput.values();
        int n = systemOutputArray.length;
        int n2 = 0;
        while (n2 < n) {
            SystemOutput systemOutput = systemOutputArray[n2];
            PrintStreamCoordinatorImpl.restoreSystemOutput(systemOutput);
            ++n2;
        }
    }

    private static void restoreSystemOutput(SystemOutput systemOutput) {
        SLF4JPrintStream slf4jPrintStream = (SLF4JPrintStream)((Object)systemOutput.get());
        systemOutput.set(slf4jPrintStream.getOriginalPrintStream());
    }
}

