/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.command;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.storm.blobstore.BlobStore;
import org.apache.storm.cluster.ClusterStateContext;
import org.apache.storm.cluster.ClusterUtils;
import org.apache.storm.cluster.DaemonType;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.daemon.nimbus.Nimbus;
import org.apache.storm.generated.Credentials;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.nimbus.NimbusInfo;
import org.apache.storm.shade.org.apache.zookeeper.ZkCli;
import org.apache.storm.thrift.TBase;
import org.apache.storm.thrift.TFieldIdEnum;
import org.apache.storm.thrift.meta_data.FieldMetaData;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.ServerUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminCommands {
    private static final Logger LOG = LoggerFactory.getLogger(AdminCommands.class);
    public static final Map<String, AdminCommand> COMMANDS = new HashMap<String, AdminCommand>();

    public static String prettyPrint(TBase value) {
        StringBuilder builder = new StringBuilder();
        AdminCommands.prettyPrint(value, 0, builder);
        return builder.toString();
    }

    private static void prettyPrint(TBase value, int depth, StringBuilder out) {
        if (value == null) {
            AdminCommands.println(out, depth, "null");
            return;
        }
        AdminCommands.println(out, depth, "{");
        AdminCommands.prettyPrintFields(value, depth + 1, out);
        AdminCommands.println(out, depth, "}");
    }

    private static void println(StringBuilder out, int depth, Object value) {
        for (int i = 0; i < depth; ++i) {
            out.append("\t");
        }
        out.append(value);
        out.append("\n");
    }

    private static void prettyPrintFields(TBase value, int depth, StringBuilder out) {
        for (Map.Entry e : FieldMetaData.getStructMetaDataMap(value.getClass()).entrySet()) {
            Map.Entry entry;
            if (!(e instanceof Map.Entry) || !((entry = e) instanceof TFieldIdEnum)) continue;
            TFieldIdEnum key = (TFieldIdEnum)entry.getKey();
            if (!value.isSet(key)) {
                AdminCommands.println(out, depth, key.getFieldName() + ": not set");
                continue;
            }
            Object o = value.getFieldValue(key);
            AdminCommands.prettyPrintKeyValue(key.getFieldName(), o, depth, out);
        }
    }

    private static String keyStr(String key) {
        return key == null ? "" : key + ": ";
    }

    private static void prettyPrintKeyValue(String key, Object o, int depth, StringBuilder out) {
        if ("json_conf".equals(key) && o instanceof String) {
            try {
                o = Utils.parseJson((String)((String)o));
            }
            catch (Exception e) {
                LOG.error("Could not parse json_conf as JSON", (Throwable)e);
            }
        }
        if (o instanceof TBase) {
            AdminCommands.println(out, depth, AdminCommands.keyStr(key) + "{");
            AdminCommands.prettyPrintFields((TBase)o, depth + 1, out);
            AdminCommands.println(out, depth, "}");
        } else if (o instanceof Map) {
            AdminCommands.println(out, depth, AdminCommands.keyStr(key) + "{");
            for (Map.Entry entry : ((Map)o).entrySet()) {
                AdminCommands.prettyPrintKeyValue(entry.getKey().toString(), entry.getValue(), depth + 1, out);
            }
            AdminCommands.println(out, depth, "}");
        } else if (o instanceof Collection) {
            AdminCommands.println(out, depth, AdminCommands.keyStr(key) + "[");
            for (Object sub : (Collection)o) {
                AdminCommands.prettyPrintKeyValue(null, sub, depth + 1, out);
            }
            AdminCommands.println(out, depth, "]");
        } else if (o instanceof String) {
            AdminCommands.println(out, depth, AdminCommands.keyStr(key) + "\"" + String.valueOf(o) + "\"");
        } else {
            AdminCommands.println(out, depth, AdminCommands.keyStr(key) + String.valueOf(o));
        }
    }

    static void help(String message, PrintStream out) {
        if (message != null) {
            out.println(message);
        }
        out.println("storm admin <command> [args]");
        out.println();
        for (Map.Entry<String, AdminCommand> entry : COMMANDS.entrySet()) {
            entry.getValue().printCliHelp(entry.getKey(), out);
            out.println();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            AdminCommands.help("Missing command.", System.err);
            System.exit(1);
        }
        String commandName = args[0].toLowerCase();
        String[] newArgs = Arrays.copyOfRange(args, 1, args.length);
        AdminCommand command = COMMANDS.get(commandName);
        if (command == null) {
            AdminCommands.help(commandName + " is not a supported command", System.err);
            System.exit(2);
        }
        try {
            command.run(newArgs, Utils.readStormConfig(), commandName);
        }
        catch (Exception e) {
            LOG.error("Error while running command {}", (Object)commandName, (Object)e);
            AdminCommands.help("Error while running " + commandName + " " + e.getMessage(), System.err);
            System.exit(3);
        }
    }

    static {
        COMMANDS.put("remove_corrupt_topologies", new RemoveCorruptTopologies());
        COMMANDS.put("zk_cli", new ZkCli());
        COMMANDS.put("creds", new CredentialsDebug());
        COMMANDS.put("help", new Help());
        COMMANDS.put("print_topo", new PrintTopo());
        COMMANDS.put("print_super", new PrintSupervisors());
        COMMANDS.put("print_assignment", new PrintAssignments());
    }

    public static interface AdminCommand {
        public void run(String[] var1, Map<String, Object> var2, String var3) throws Exception;

        public void printCliHelp(String var1, PrintStream var2);
    }

    private static class RemoveCorruptTopologies
    implements AdminCommand {
        private RemoveCorruptTopologies() {
        }

        @Override
        public void run(String[] args, Map<String, Object> conf, String command) throws Exception {
            try (BlobStore nimbusBlobStore = ServerUtils.getNimbusBlobStore(conf, (NimbusInfo)NimbusInfo.fromConf(conf), null);){
                IStormClusterState stormClusterState = ClusterUtils.mkStormClusterState(conf, (ClusterStateContext)new ClusterStateContext(DaemonType.NIMBUS, conf));
                Set blobStoreTopologyIds = nimbusBlobStore.filterAndListKeys(key -> ConfigUtils.getIdFromBlobKey((String)key));
                HashSet activeTopologyIds = new HashSet(stormClusterState.activeStorms());
                Sets.SetView diffTopology = Sets.difference(activeTopologyIds, (Set)blobStoreTopologyIds);
                LOG.info("active-topology-ids [{}] blob-topology-ids [{}] diff-topology [{}]", new Object[]{activeTopologyIds, blobStoreTopologyIds, diffTopology});
                for (String corruptId : diffTopology) {
                    stormClusterState.removeStorm(corruptId);
                }
            }
        }

        @Override
        public void printCliHelp(String command, PrintStream out) {
            out.println(command + ":");
            out.println("\tKill topologies that appear to be corrupted (missing blobs).");
        }
    }

    private static class CredentialsDebug
    implements AdminCommand {
        private CredentialsDebug() {
        }

        @Override
        public void run(String[] args, Map<String, Object> conf, String command) throws Exception {
            IStormClusterState state = ClusterUtils.mkStormClusterState(conf, (ClusterStateContext)new ClusterStateContext(DaemonType.NIMBUS, conf));
            for (String topologyId : args) {
                System.out.println(topologyId + ":");
                Credentials creds = state.credentials(topologyId, null);
                if (creds == null) continue;
                for (String key : creds.get_creds().keySet()) {
                    System.out.println("\t" + key);
                }
            }
        }

        @Override
        public void printCliHelp(String command, PrintStream out) {
            out.println(command + " topology_id:");
            out.println("\tPrint the credential keys for a topology.");
        }
    }

    private static class Help
    implements AdminCommand {
        private Help() {
        }

        @Override
        public void run(String[] args, Map<String, Object> conf, String command) {
            if (args.length <= 0) {
                AdminCommands.help(null, System.out);
            } else {
                for (String cn : args) {
                    AdminCommand c = COMMANDS.get(cn);
                    if (c == null) {
                        throw new IllegalArgumentException(cn + " is not a supported command");
                    }
                    c.printCliHelp(cn, System.out);
                }
            }
        }

        @Override
        public void printCliHelp(String command, PrintStream out) {
            out.println(command + " [<command>...]:");
            out.println("\tPrint a help message about one or more commands.  If not commands are given, print all");
        }
    }

    private static class PrintTopo
    implements AdminCommand {
        private PrintTopo() {
        }

        @Override
        public void run(String[] args, Map<String, Object> conf, String command) throws Exception {
            for (String arg : args) {
                StormTopology topo;
                System.out.println(arg + ":");
                File f = new File(arg);
                if (f.exists()) {
                    topo = (StormTopology)Utils.deserialize((byte[])FileUtils.readFileToByteArray((File)f), StormTopology.class);
                } else {
                    String key = ConfigUtils.masterStormCodeKey((String)arg);
                    try (BlobStore store = ServerUtils.getNimbusBlobStore(conf, (NimbusInfo)NimbusInfo.fromConf(conf), null);){
                        topo = (StormTopology)Utils.deserialize((byte[])store.readBlob(key, Nimbus.NIMBUS_SUBJECT), StormTopology.class);
                    }
                }
                System.out.println(AdminCommands.prettyPrint((TBase)topo));
            }
        }

        @Override
        public void printCliHelp(String command, PrintStream out) {
            out.println(command + " [topology_id|file]*:");
            out.println("\tPrint a human readable version of the topology");
        }
    }

    private static class PrintSupervisors
    implements AdminCommand {
        private PrintSupervisors() {
        }

        @Override
        public void run(String[] args, Map<String, Object> conf, String command) throws Exception {
            IStormClusterState stormClusterState = ClusterUtils.mkStormClusterState(conf, (ClusterStateContext)new ClusterStateContext(DaemonType.NIMBUS, conf));
            Map infos = stormClusterState.allSupervisorInfo();
            if (args.length <= 0) {
                for (Map.Entry entry : infos.entrySet()) {
                    System.out.println((String)entry.getKey() + ":");
                    System.out.println(AdminCommands.prettyPrint((TBase)entry.getValue()));
                }
            } else {
                for (String arg : args) {
                    System.out.println(arg + ":");
                    System.out.println(AdminCommands.prettyPrint((TBase)infos.get(arg)));
                }
            }
        }

        @Override
        public void printCliHelp(String command, PrintStream out) {
            out.println(command + " [supervisor_id]*:");
            out.println("\tPrint a human readable version of the supervisor info(s). Print all if no args");
        }
    }

    private static class PrintAssignments
    implements AdminCommand {
        private PrintAssignments() {
        }

        @Override
        public void run(String[] args, Map<String, Object> conf, String command) throws Exception {
            IStormClusterState stormClusterState = ClusterUtils.mkStormClusterState(conf, (ClusterStateContext)new ClusterStateContext(DaemonType.NIMBUS, conf));
            stormClusterState.syncRemoteAssignments(null);
            stormClusterState.syncRemoteIds(null);
            stormClusterState.setAssignmentsBackendSynchronized();
            Map infos = stormClusterState.assignmentsInfo();
            if (args.length <= 0) {
                for (Map.Entry entry : infos.entrySet()) {
                    System.out.println((String)entry.getKey() + ":");
                    System.out.println(AdminCommands.prettyPrint((TBase)entry.getValue()));
                }
            } else {
                for (String arg : args) {
                    System.out.println(arg + ":");
                    System.out.println(AdminCommands.prettyPrint((TBase)infos.get(arg)));
                }
            }
        }

        @Override
        public void printCliHelp(String command, PrintStream out) {
            out.println(command + " [topology_id]*:");
            out.println("\tPrint a human readable version of the topologies assignment info(s). Print all if no args");
        }
    }
}

