/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.plan;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.typeutils.TypeComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.costs.Costs;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.optimizer.dag.WorksetIterationNode;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.DualInputPlanNode;
import org.apache.flink.optimizer.plan.IterationPlanNode;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.optimizer.plan.SolutionSetPlanNode;
import org.apache.flink.optimizer.plan.WorksetPlanNode;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.util.Visitor;

public class WorksetIterationPlanNode
extends DualInputPlanNode
implements IterationPlanNode {
    private final SolutionSetPlanNode solutionSetPlanNode;
    private final WorksetPlanNode worksetPlanNode;
    private final PlanNode solutionSetDeltaPlanNode;
    private final PlanNode nextWorkSetPlanNode;
    private TypeSerializerFactory<?> worksetSerializer;
    private TypeSerializerFactory<?> solutionSetSerializer;
    private TypeComparatorFactory<?> solutionSetComparator;
    private boolean immediateSolutionSetUpdate;
    public Object postPassHelper;
    private TypeSerializerFactory<?> serializerForIterationChannel;

    public WorksetIterationPlanNode(WorksetIterationNode template, String nodeName, Channel initialSolutionSet, Channel initialWorkset, SolutionSetPlanNode solutionSetPlanNode, WorksetPlanNode worksetPlanNode, PlanNode nextWorkSetPlanNode, PlanNode solutionSetDeltaPlanNode) {
        super(template, nodeName, initialSolutionSet, initialWorkset, DriverStrategy.BINARY_NO_OP);
        this.solutionSetPlanNode = solutionSetPlanNode;
        this.worksetPlanNode = worksetPlanNode;
        this.solutionSetDeltaPlanNode = solutionSetDeltaPlanNode;
        this.nextWorkSetPlanNode = nextWorkSetPlanNode;
        this.mergeBranchPlanMaps();
    }

    @Override
    public WorksetIterationNode getIterationNode() {
        if (this.template instanceof WorksetIterationNode) {
            return (WorksetIterationNode)this.template;
        }
        throw new RuntimeException();
    }

    public SolutionSetPlanNode getSolutionSetPlanNode() {
        return this.solutionSetPlanNode;
    }

    public WorksetPlanNode getWorksetPlanNode() {
        return this.worksetPlanNode;
    }

    public PlanNode getSolutionSetDeltaPlanNode() {
        return this.solutionSetDeltaPlanNode;
    }

    public PlanNode getNextWorkSetPlanNode() {
        return this.nextWorkSetPlanNode;
    }

    public Channel getInitialSolutionSetInput() {
        return this.getInput1();
    }

    public Channel getInitialWorksetInput() {
        return this.getInput2();
    }

    public void setImmediateSolutionSetUpdate(boolean immediateUpdate) {
        this.immediateSolutionSetUpdate = immediateUpdate;
    }

    public boolean isImmediateSolutionSetUpdate() {
        return this.immediateSolutionSetUpdate;
    }

    public FieldList getSolutionSetKeyFields() {
        return this.getIterationNode().getSolutionSetKeyFields();
    }

    public TypeSerializerFactory<?> getWorksetSerializer() {
        return this.worksetSerializer;
    }

    public void setWorksetSerializer(TypeSerializerFactory<?> worksetSerializer) {
        this.worksetSerializer = worksetSerializer;
    }

    public TypeSerializerFactory<?> getSolutionSetSerializer() {
        return this.solutionSetSerializer;
    }

    public void setSolutionSetSerializer(TypeSerializerFactory<?> solutionSetSerializer) {
        this.solutionSetSerializer = solutionSetSerializer;
    }

    public TypeComparatorFactory<?> getSolutionSetComparator() {
        return this.solutionSetComparator;
    }

    public void setSolutionSetComparator(TypeComparatorFactory<?> solutionSetComparator) {
        this.solutionSetComparator = solutionSetComparator;
    }

    @Override
    public void setCosts(Costs nodeCosts) {
        nodeCosts.addCosts(this.solutionSetDeltaPlanNode.getCumulativeCostsShare());
        nodeCosts.addCosts(this.nextWorkSetPlanNode.getCumulativeCostsShare());
        super.setCosts(nodeCosts);
    }

    @Override
    public int getMemoryConsumerWeight() {
        return 2;
    }

    @Override
    public PlanNode.SourceAndDamReport hasDamOnPathDownTo(PlanNode source) {
        if (source == this) {
            return PlanNode.SourceAndDamReport.FOUND_SOURCE;
        }
        PlanNode.SourceAndDamReport fromOutside = super.hasDamOnPathDownTo(source);
        if (fromOutside == PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM) {
            return PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM;
        }
        if (fromOutside == PlanNode.SourceAndDamReport.FOUND_SOURCE) {
            return PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM;
        }
        PlanNode.SourceAndDamReport fromNextWorkset = this.nextWorkSetPlanNode.hasDamOnPathDownTo(source);
        if (fromNextWorkset == PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM) {
            return PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM;
        }
        if (fromNextWorkset == PlanNode.SourceAndDamReport.FOUND_SOURCE) {
            return PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM;
        }
        return this.solutionSetDeltaPlanNode.hasDamOnPathDownTo(source);
    }

    @Override
    public void acceptForStepFunction(Visitor<PlanNode> visitor) {
        this.solutionSetDeltaPlanNode.accept(visitor);
        this.nextWorkSetPlanNode.accept(visitor);
    }

    @Override
    protected void mergeBranchPlanMaps(Map<OptimizerNode, PlanNode> branchPlan1, Map<OptimizerNode, PlanNode> branchPlan2) {
    }

    protected void mergeBranchPlanMaps() {
        Map<OptimizerNode, PlanNode> branchPlan1 = this.input1.getSource().branchPlan;
        Map<OptimizerNode, PlanNode> branchPlan2 = this.input2.getSource().branchPlan;
        if (this.template.hasUnclosedBranches()) {
            if (this.branchPlan == null) {
                this.branchPlan = new HashMap(8);
            }
            for (OptimizerNode.UnclosedBranchDescriptor uc : this.template.getOpenBranches()) {
                OptimizerNode brancher = uc.getBranchingNode();
                PlanNode selectedCandidate = null;
                if (branchPlan1 != null) {
                    selectedCandidate = branchPlan1.get(brancher);
                }
                if (selectedCandidate == null && branchPlan2 != null) {
                    selectedCandidate = branchPlan2.get(brancher);
                }
                if (selectedCandidate == null && this.getSolutionSetDeltaPlanNode() != null && this.getSolutionSetDeltaPlanNode().branchPlan != null) {
                    selectedCandidate = this.getSolutionSetDeltaPlanNode().branchPlan.get(brancher);
                }
                if (selectedCandidate == null && this.getNextWorkSetPlanNode() != null && this.getNextWorkSetPlanNode().branchPlan != null) {
                    selectedCandidate = this.getNextWorkSetPlanNode().branchPlan.get(brancher);
                }
                if (selectedCandidate == null) {
                    throw new CompilerException("Candidates for a node with open branches are missing information about the selected candidate ");
                }
                this.branchPlan.put(brancher, selectedCandidate);
            }
        }
    }

    public TypeSerializerFactory<?> getSerializerForIterationChannel() {
        return this.serializerForIterationChannel;
    }

    public void setSerializerForIterationChannel(TypeSerializerFactory<?> serializerForIterationChannel) {
        this.serializerForIterationChannel = serializerForIterationChannel;
    }
}

