/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.CharValue;

@Internal
public class CharValueSerializer
extends TypeSerializerSingleton<CharValue> {
    private static final long serialVersionUID = 1L;
    public static final CharValueSerializer INSTANCE = new CharValueSerializer();

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public CharValue createInstance() {
        return new CharValue();
    }

    @Override
    public CharValue copy(CharValue from) {
        return this.copy(from, new CharValue());
    }

    @Override
    public CharValue copy(CharValue from, CharValue reuse) {
        reuse.setValue(from.getValue());
        return reuse;
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public void serialize(CharValue record, DataOutputView target) throws IOException {
        record.write(target);
    }

    @Override
    public CharValue deserialize(DataInputView source) throws IOException {
        return this.deserialize(new CharValue(), source);
    }

    @Override
    public CharValue deserialize(CharValue reuse, DataInputView source) throws IOException {
        reuse.read(source);
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeChar(source.readChar());
    }

    @Override
    public TypeSerializerSnapshot<CharValue> snapshotConfiguration() {
        return new CharValueSerializerSnapshot();
    }

    public static final class CharValueSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<CharValue> {
        public CharValueSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

