/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;

@Internal
public final class PrioritizedDeque<T>
implements Iterable<T> {
    private final Deque<T> deque = new ArrayDeque<T>();
    private int numPriorityElements;

    public void addPriorityElement(T element) {
        if (this.numPriorityElements == 0) {
            this.deque.addFirst(element);
        } else if (this.numPriorityElements == this.deque.size()) {
            this.deque.add(element);
        } else {
            ArrayDeque<T> priorPriority = new ArrayDeque<T>(this.numPriorityElements);
            for (int index = 0; index < this.numPriorityElements; ++index) {
                priorPriority.addFirst(this.deque.poll());
            }
            this.deque.addFirst(element);
            for (Object priorityEvent : priorPriority) {
                this.deque.addFirst(priorityEvent);
            }
        }
        ++this.numPriorityElements;
    }

    public void add(T element) {
        this.deque.add(element);
    }

    public void add(T element, boolean priority, boolean prioritize) {
        if (!priority) {
            this.add(element);
        } else if (prioritize) {
            this.prioritize(element);
        } else {
            this.addPriorityElement(element);
        }
    }

    public void prioritize(T element) {
        Iterator<T> iterator = this.deque.iterator();
        for (int i = 0; i < this.numPriorityElements && iterator.hasNext(); ++i) {
            if (iterator.next() != element) continue;
            return;
        }
        if (iterator.hasNext() && iterator.next() == element) {
            ++this.numPriorityElements;
            return;
        }
        while (iterator.hasNext()) {
            if (iterator.next() != element) continue;
            iterator.remove();
            break;
        }
        this.addPriorityElement(element);
    }

    public Collection<T> asUnmodifiableCollection() {
        return Collections.unmodifiableCollection(this.deque);
    }

    public T getAndRemove(Predicate<T> preCondition) {
        Iterator<T> iterator = this.deque.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (preCondition.test(next)) {
                if (i < this.numPriorityElements) {
                    --this.numPriorityElements;
                }
                iterator.remove();
                return next;
            }
            ++i;
        }
        throw new NoSuchElementException();
    }

    @Nullable
    public T poll() {
        T polled = this.deque.poll();
        if (polled != null && this.numPriorityElements > 0) {
            --this.numPriorityElements;
        }
        return polled;
    }

    @Nullable
    public T peek() {
        return this.deque.peek();
    }

    public int getNumPriorityElements() {
        return this.numPriorityElements;
    }

    public boolean containsPriorityElement(T element) {
        if (this.numPriorityElements == 0) {
            return false;
        }
        Iterator<T> iterator = this.deque.iterator();
        for (int i = 0; i < this.numPriorityElements && iterator.hasNext(); ++i) {
            if (iterator.next() != element) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.deque.size();
    }

    public int getNumUnprioritizedElements() {
        return this.size() - this.getNumPriorityElements();
    }

    @Override
    public Iterator<T> iterator() {
        return Collections.unmodifiableCollection(this.deque).iterator();
    }

    public void clear() {
        this.deque.clear();
        this.numPriorityElements = 0;
    }

    public boolean isEmpty() {
        return this.deque.isEmpty();
    }

    public boolean contains(T element) {
        if (this.deque.isEmpty()) {
            return false;
        }
        Iterator<T> iterator = this.deque.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != element) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrioritizedDeque that = (PrioritizedDeque)o;
        return this.numPriorityElements == that.numPriorityElements && this.deque.equals(that.deque);
    }

    public int hashCode() {
        return Objects.hash(this.deque, this.numPriorityElements);
    }

    public String toString() {
        return this.deque.toString();
    }

    @Nullable
    public T peekLast() {
        return this.deque.peekLast();
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

