/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.com.google.common.io;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.io.Bytes;
import com.google.gxp.com.google.common.io.Characters;
import com.google.gxp.com.google.common.io.IoSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;

public final class Resources {
    public static IoSupplier<InputStream> newInputStreamSupplier(final URL url) {
        Preconditions.checkNotNull(url);
        return new IoSupplier<InputStream>(){

            @Override
            public InputStream get() throws IOException {
                return url.openStream();
            }
        };
    }

    public static IoSupplier<InputStreamReader> newReaderSupplier(URL url, Charset charset) {
        return Characters.newReaderSupplier(Resources.newInputStreamSupplier(url), charset);
    }

    public static byte[] toByteArray(URL url) throws IOException {
        return Bytes.toByteArray(Resources.newInputStreamSupplier(url));
    }

    public static String toString(URL url, Charset charset) throws IOException {
        return Characters.toString(Resources.newReaderSupplier(url, charset));
    }

    public static List<String> readLines(URL url, Charset charset) throws IOException {
        return Characters.readLines(Resources.newReaderSupplier(url, charset));
    }

    public static void copy(URL url, OutputStream to) throws IOException {
        Bytes.copy(Resources.newInputStreamSupplier(url), to);
    }
}

