/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.parser;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.parser.Namespace;
import com.google.gxp.compiler.parser.NamespaceVisitor;
import com.google.gxp.compiler.parser.ParsedAttribute;
import com.google.gxp.compiler.parser.ParsedElement;
import com.google.gxp.compiler.parser.ParsedElementVisitor;
import com.google.gxp.compiler.parser.UnknownElementError;
import com.google.gxp.compiler.schema.ElementValidator;
import com.google.gxp.compiler.schema.Schema;
import java.util.List;

public class OutputNamespace
implements Namespace {
    private final Schema schema;

    @Override
    public String getUri() {
        return this.schema.getNamespaceUri();
    }

    public OutputNamespace(Schema schema) {
        this.schema = Preconditions.checkNotNull(schema);
    }

    @Override
    public ParsedElement createElement(AlertSink alertSink, SourcePosition sourcePosition, String displayName, String tagName, List<ParsedAttribute> attrs, List<ParsedElement> children) {
        ElementValidator validator = this.schema.getElementValidator(tagName);
        if (validator == null) {
            alertSink.add(new UnknownElementError(sourcePosition, this, displayName));
            return null;
        }
        return new ParsedOutputElement(sourcePosition, displayName, this.schema, validator, attrs, children);
    }

    @Override
    public <T> T acceptVisitor(NamespaceVisitor<T> visitor) {
        return visitor.visitOutputNamespace(this);
    }

    public static class ParsedOutputElement
    extends ParsedElement {
        private final Schema schema;
        private final ElementValidator validator;

        public ParsedOutputElement(SourcePosition sourcePosition, String displayName, Schema schema, ElementValidator validator, List<ParsedAttribute> attrs, List<ParsedElement> children) {
            super(sourcePosition, displayName, attrs, children);
            this.schema = schema;
            this.validator = validator;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public ElementValidator getValidator() {
            return this.validator;
        }

        @Override
        public <T> T acceptVisitor(ParsedElementVisitor<T> visitor) {
            return visitor.visitParsedOutputElement(this);
        }

        @Override
        protected ParsedOutputElement withChildrenImpl(List<ParsedElement> children) {
            return new ParsedOutputElement(this.getSourcePosition(), this.getDisplayName(), this.schema, this.validator, this.getAttributes(), children);
        }
    }
}

