/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.util.regex.Pattern;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.ValidationCycle;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.Email;
import net.sf.oval.exception.OValException;

public class EmailCheck
extends AbstractAnnotationCheck<Email> {
    private static final long serialVersionUID = 1L;
    private static final String SPECIAL_CHARACTERS = "'\\(\\)\\-\\.`";
    private static final String ASCII = "\\w '\\(\\)\\-\\.`";
    private static final String ASCII_WITHOUT_COMMA = "[\\w '\\(\\)\\-\\.`]+";
    private static final String ASCII_WITH_COMMA = "\"[\\w '\\(\\)\\-\\.`,]+\"";
    private static final String ASCII_WITH_QUESTION_MARK_AND_EQUALS = "[\\w '\\(\\)\\-\\.`\\?\\=]+";
    private static final String MIME_ENCODED = "\\=\\?[\\w '\\(\\)\\-\\.`\\?\\=]+\\?\\=";
    private static final String NAME = "([\\w '\\(\\)\\-\\.`]+|\"[\\w '\\(\\)\\-\\.`,]+\"|\\=\\?[\\w '\\(\\)\\-\\.`\\?\\=]+\\?\\=)";
    private static final String EMAIL_BASE_PATTERN = "['_A-Za-z0-9-&+]+(\\.['_A-Za-z0-9-&+]+)*[.]{0,1}@([A-Za-z0-9-])+(\\.[A-Za-z0-9-]+)*((\\.[A-Za-z0-9]{2,})|(\\.[A-Za-z0-9]{2,}\\.[A-Za-z0-9]{2,}))";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^['_A-Za-z0-9-&+]+(\\.['_A-Za-z0-9-&+]+)*[.]{0,1}@([A-Za-z0-9-])+(\\.[A-Za-z0-9-]+)*((\\.[A-Za-z0-9]{2,})|(\\.[A-Za-z0-9]{2,}\\.[A-Za-z0-9]{2,}))$");
    private static final Pattern EMAIL_WITH_PERSONAL_NAME_PATTERN = Pattern.compile("^(['_A-Za-z0-9-&+]+(\\.['_A-Za-z0-9-&+]+)*[.]{0,1}@([A-Za-z0-9-])+(\\.[A-Za-z0-9-]+)*((\\.[A-Za-z0-9]{2,})|(\\.[A-Za-z0-9]{2,}\\.[A-Za-z0-9]{2,}))|([\\w '\\(\\)\\-\\.`]+|\"[\\w '\\(\\)\\-\\.`,]+\"|\\=\\?[\\w '\\(\\)\\-\\.`\\?\\=]+\\?\\=) +<['_A-Za-z0-9-&+]+(\\.['_A-Za-z0-9-&+]+)*[.]{0,1}@([A-Za-z0-9-])+(\\.[A-Za-z0-9-]+)*((\\.[A-Za-z0-9]{2,})|(\\.[A-Za-z0-9]{2,}\\.[A-Za-z0-9]{2,}))>)$");
    private boolean allowPersonalName;

    @Override
    public void configure(Email constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setAllowPersonalName(constraintAnnotation.allowPersonalName());
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public boolean isAllowPersonalName() {
        return this.allowPersonalName;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, ValidationCycle cycle) throws OValException {
        if (valueToValidate == null) {
            return true;
        }
        if (this.allowPersonalName) {
            return EMAIL_WITH_PERSONAL_NAME_PATTERN.matcher(valueToValidate.toString()).matches();
        }
        return EMAIL_PATTERN.matcher(valueToValidate.toString()).matches();
    }

    public void setAllowPersonalName(boolean allowPersonalName) {
        this.allowPersonalName = allowPersonalName;
    }
}

