/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.struts2.util;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.DispatcherErrorHandler;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

import static java.util.Collections.emptyMap;

/**
 * Generic test setup methods to be used with any unit testing framework.
 */
public class StrutsTestCaseHelper {

    public static Dispatcher initDispatcher(ServletContext ctx, Map<String, String> params) {
        Dispatcher du = new DispatcherWrapper(ctx, params != null ? params : emptyMap());
        du.init();
        Dispatcher.setInstance(du);

        // Reset the value stack
        Container container = du.getContainer();
        ValueStack stack = container.getInstance(ValueStackFactory.class).createValueStack();
        stack.getActionContext().withContainer(container).withValueStack(stack).bind();

        return du;
    }

    public static void tearDown(Dispatcher dispatcher) {
        if (dispatcher != null && dispatcher.getConfigurationManager() != null) {
            dispatcher.cleanup();
        }
        tearDown();
    }

    public static void tearDown() {
        (new Dispatcher(null, null)).cleanUpAfterInit(); // Clear ContainerHolder
        Dispatcher.clearInstance();
        ActionContext.clear();
    }

    private static class DispatcherWrapper extends Dispatcher {

        public DispatcherWrapper(ServletContext ctx, Map<String, String> params) {
            super(ctx, params);
            super.setDispatcherErrorHandler(new MockErrorHandler());
        }

        @Override
        public void setDispatcherErrorHandler(DispatcherErrorHandler errorHandler) {
            // ignore
        }
    }

    private static class MockErrorHandler implements DispatcherErrorHandler {
        public void init(ServletContext ctx) {
            // ignore
        }

        public void handleError(HttpServletRequest request, HttpServletResponse response, int code, Exception e) {
            System.out.println("Dispatcher#sendError: " + code);
            e.printStackTrace(System.out);
        }
    }

}
