/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.com.google.common.io;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBuffers {
    private ByteBuffers() {
    }

    public static ByteBuffer allocate(int capacity) {
        return ByteBuffer.allocate(capacity).order(ByteOrder.LITTLE_ENDIAN);
    }

    public static ByteBuffer allocateDirect(int capacity) {
        return ByteBuffer.allocateDirect(capacity).order(ByteOrder.LITTLE_ENDIAN);
    }

    public static ByteBuffer allocateDirectAndFlip(int capacity) {
        ByteBuffer buf = ByteBuffer.allocateDirect(capacity).order(ByteOrder.LITTLE_ENDIAN);
        buf.flip();
        return buf;
    }

    public static ByteBuffer wrap(byte[] array) {
        return ByteBuffer.wrap(array).order(ByteOrder.LITTLE_ENDIAN);
    }

    public static byte[] extractBytes(ByteBuffer buf) {
        if (buf.hasArray() && buf.arrayOffset() == 0 && buf.position() == 0 && buf.limit() == buf.capacity()) {
            return buf.array();
        }
        byte[] result = new byte[buf.remaining()];
        buf.get(result);
        buf.position(buf.position() - result.length);
        return result;
    }
}

