/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.schema;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.SerializableAbstractNode;
import com.google.gxp.compiler.schema.ContentFamily;
import com.google.gxp.compiler.schema.ElementBuilder;
import com.google.gxp.compiler.schema.ElementValidator;
import com.google.gxp.compiler.schema.SchemaRef;
import java.util.Collection;
import java.util.List;

public final class Schema
extends SerializableAbstractNode
implements Comparable<Schema> {
    private final String name;
    private final String namespaceUri;
    private final String contentType;
    private final boolean defaultsToSgml;
    private final String sgmlContentType;
    private final String tagPrefix;
    private final ImmutableMap<String, ElementValidator> validatorMap;
    private final String cppType;
    private final String cppAppender;
    private final ImmutableList<String> cppImports;
    private final String javaType;
    private final String javaAppender;
    private final ImmutableList<String> javaImports;
    private final String javaScriptType;
    private final ContentFamily contentFamily;
    private final ImmutableList<SchemaRef> allowedSchemaRefs;
    private final Schema msgSchema;

    public String getName() {
        return this.name;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getXmlContentType() {
        return this.contentType;
    }

    public boolean defaultsToSgml() {
        return this.defaultsToSgml;
    }

    public String getSgmlContentType() {
        return this.sgmlContentType;
    }

    public String getCanonicalContentType() {
        return this.defaultsToSgml() ? this.getSgmlContentType() : this.getXmlContentType();
    }

    public String getTagPrefix() {
        return this.tagPrefix;
    }

    public String getCppType() {
        return this.cppType;
    }

    public String getCppAppender() {
        return this.cppAppender;
    }

    public List<String> getCppImports() {
        return this.cppImports;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public String getJavaAppender() {
        return this.javaAppender;
    }

    public List<String> getJavaImports() {
        return this.javaImports;
    }

    public String getJavaScriptType() {
        return this.javaScriptType;
    }

    public ContentFamily getContentFamily() {
        return this.contentFamily;
    }

    public Schema getMsgSchema() {
        return this.msgSchema == null ? this : this.msgSchema;
    }

    public boolean isTranslatable() {
        return this.msgSchema == null || this.msgSchema.equals(this);
    }

    public String toString() {
        return this.getCanonicalContentType();
    }

    public boolean allows(Schema schema) {
        if (schema == this) {
            return true;
        }
        for (SchemaRef ref : this.allowedSchemaRefs) {
            if (!ref.getContentType().equals(schema.getXmlContentType()) && !ref.getContentType().equals(schema.getSgmlContentType())) continue;
            return true;
        }
        return false;
    }

    public Schema(SourcePosition pos, String displayName, String name, String namespaceUri, String contentType, boolean defaultsToSgml, String sgmlContentType, String tagPrefix, String cppType, String cppAppender, List<String> cppImports, String javaType, String javaAppender, List<String> javaImports, String javaScriptType, Iterable<ElementBuilder> elementBuilders, Collection<SchemaRef> allowedSchemaRefs, Schema msgSchema) {
        super(pos, displayName);
        this.name = Preconditions.checkNotNull(name);
        this.namespaceUri = Preconditions.checkNotNull(namespaceUri);
        this.contentType = contentType;
        this.defaultsToSgml = defaultsToSgml;
        this.sgmlContentType = sgmlContentType;
        this.tagPrefix = tagPrefix;
        this.cppType = cppType;
        this.cppAppender = cppAppender;
        this.cppImports = ImmutableList.copyOf(cppImports);
        this.javaType = Preconditions.checkNotNull(javaType);
        this.javaAppender = javaAppender;
        this.javaImports = ImmutableList.copyOf((Iterable)Preconditions.checkNotNull(javaImports));
        this.javaScriptType = javaScriptType;
        this.contentFamily = ContentFamily.fromContentTypeName(this.getCanonicalContentType());
        ImmutableMap.Builder<String, ElementValidator> validatorMapBuilder = ImmutableMap.builder();
        for (ElementBuilder elementBuilder : elementBuilders) {
            ElementValidator validator = elementBuilder.build();
            validatorMapBuilder.put(validator.getTagName(), validator);
        }
        this.validatorMap = validatorMapBuilder.build();
        this.allowedSchemaRefs = ImmutableList.copyOf(allowedSchemaRefs);
        this.msgSchema = msgSchema;
    }

    public ElementValidator getElementValidator(String tagName) {
        return this.validatorMap.get(tagName);
    }

    @Override
    public int compareTo(Schema that) {
        return this.getCanonicalContentType().compareTo(that.getCanonicalContentType());
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Schema && this.equals((Schema)that);
    }

    private boolean equals(Schema that) {
        return this.equalsAbstractNode(that) && Objects.equal(this.getName(), that.getName()) && Objects.equal(this.getNamespaceUri(), that.getNamespaceUri()) && Objects.equal(this.getXmlContentType(), that.getXmlContentType()) && this.defaultsToSgml() == that.defaultsToSgml() && Objects.equal(this.getSgmlContentType(), that.getSgmlContentType()) && Objects.equal(this.getTagPrefix(), that.getTagPrefix()) && Objects.equal(this.getCppType(), that.getCppType()) && Objects.equal(this.getCppAppender(), that.getCppAppender()) && Objects.equal(this.getCppImports(), that.getCppImports()) && Objects.equal(this.getJavaType(), that.getJavaType()) && Objects.equal(this.getJavaAppender(), that.getJavaAppender()) && Objects.equal(this.getJavaImports(), that.getJavaImports()) && Objects.equal(this.getJavaScriptType(), that.getJavaScriptType()) && Objects.equal((Object)this.getContentFamily(), (Object)that.getContentFamily()) && Objects.equal(this.allowedSchemaRefs, that.allowedSchemaRefs) && Objects.equal(this.validatorMap, that.validatorMap) && Objects.equal(this.msgSchema, that.msgSchema);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.abstractNodeHashCode(), this.getName(), this.getNamespaceUri(), this.getXmlContentType(), this.defaultsToSgml(), this.getSgmlContentType(), this.getTagPrefix(), this.getCppType(), this.getCppAppender(), this.getCppImports(), this.getJavaType(), this.getJavaAppender(), this.getJavaImports(), this.getJavaScriptType(), this.getContentFamily(), this.allowedSchemaRefs, this.validatorMap, this.msgSchema});
    }
}

