/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.core.definition.digester;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.Rule;
import org.apache.struts2.StrutsException;
import org.apache.tiles.api.Attribute;
import org.apache.tiles.api.Definition;
import org.apache.tiles.api.ListAttribute;
import org.apache.tiles.core.definition.DefinitionsFactoryException;
import org.apache.tiles.core.definition.DefinitionsReader;
import org.apache.tiles.core.definition.digester.AddNestedDefinitionRule;
import org.apache.tiles.core.definition.digester.DigesterDefinitionsReaderException;
import org.apache.tiles.core.definition.digester.FillAttributeRule;
import org.apache.tiles.core.definition.digester.FillDefinitionRule;
import org.apache.tiles.core.definition.digester.PutAttributeRule;
import org.apache.tiles.core.definition.digester.ThrowingErrorHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class DigesterDefinitionsReader
implements DefinitionsReader {
    private static final String DEFINITION_TAG = "tiles-definitions/definition";
    private static final String PUT_TAG = "*/definition/put-attribute";
    private static final String PUT_DEFINITION_TAG = "*/put-attribute/definition";
    private static final String ADD_DEFINITION_TAG = "*/add-attribute/definition";
    private static final String DEF_LIST_TAG = "*/definition/put-list-attribute";
    private static final String ADD_LIST_ELE_TAG = "*/add-attribute";
    private static final String NESTED_LIST = "*/add-list-attribute";
    protected static final String DEFINITION_HANDLER_CLASS = Definition.class.getName();
    protected static final String PUT_ATTRIBUTE_HANDLER_CLASS = Attribute.class.getName();
    protected static final String LIST_HANDLER_CLASS = ListAttribute.class.getName();
    private String[] registrations;
    protected final Digester digester = new Digester();
    protected Map<String, Definition> definitions;

    public DigesterDefinitionsReader() {
        this.digester.setNamespaceAware(true);
        this.digester.setUseContextClassLoader(true);
        this.digester.setErrorHandler((ErrorHandler)new ThrowingErrorHandler());
        try {
            this.digester.setFeature("http://xml.org/sax/features/external-general-entities", false);
            this.digester.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            this.digester.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            this.digester.setXIncludeAware(false);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new StrutsException("Unable to disable external XML entity parsing", (Throwable)e);
        }
        String[] registrations = this.getRegistrations();
        for (int i = 0; i < registrations.length; i += 2) {
            URL url = this.getClass().getResource(registrations[i + 1]);
            if (url == null) continue;
            this.digester.register(registrations[i], url.toString());
        }
        this.initSyntax(this.digester);
    }

    public void setValidating(boolean validating) {
        this.digester.setValidating(validating);
    }

    @Override
    public Map<String, Definition> read(Object source) {
        InputStream input;
        this.definitions = new LinkedHashMap<String, Definition>();
        if (source == null) {
            return null;
        }
        try {
            input = (InputStream)source;
        }
        catch (ClassCastException e) {
            throw new DefinitionsFactoryException("Invalid source type.  Requires java.io.InputStream.", e);
        }
        try {
            this.digester.push((Object)this);
            this.digester.parse(input);
        }
        catch (SAXException e) {
            throw new DefinitionsFactoryException("XML error reading definitions.", e);
        }
        catch (IOException e) {
            throw new DefinitionsFactoryException("I/O Error reading definitions.", e);
        }
        finally {
            this.digester.clear();
        }
        return this.definitions;
    }

    protected void initSyntax(Digester digester) {
        this.initDigesterForTilesDefinitionsSyntax(digester);
    }

    private void initDigesterForTilesDefinitionsSyntax(Digester digester) {
        digester.addObjectCreate(DEFINITION_TAG, DEFINITION_HANDLER_CLASS);
        digester.addRule(DEFINITION_TAG, (Rule)new FillDefinitionRule(digester));
        digester.addSetNext(DEFINITION_TAG, "addDefinition", DEFINITION_HANDLER_CLASS);
        digester.addObjectCreate(PUT_DEFINITION_TAG, DEFINITION_HANDLER_CLASS);
        digester.addRule(PUT_DEFINITION_TAG, (Rule)new FillDefinitionRule(digester));
        digester.addSetRoot(PUT_DEFINITION_TAG, "addDefinition");
        digester.addRule(PUT_DEFINITION_TAG, (Rule)new AddNestedDefinitionRule(this));
        digester.addObjectCreate(ADD_DEFINITION_TAG, DEFINITION_HANDLER_CLASS);
        digester.addRule(ADD_DEFINITION_TAG, (Rule)new FillDefinitionRule(digester));
        digester.addSetRoot(ADD_DEFINITION_TAG, "addDefinition");
        digester.addRule(ADD_DEFINITION_TAG, (Rule)new AddNestedDefinitionRule(this));
        digester.addObjectCreate(PUT_TAG, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addRule(PUT_TAG, (Rule)new FillAttributeRule(digester));
        digester.addRule(PUT_TAG, (Rule)new PutAttributeRule(digester));
        digester.addObjectCreate(DEF_LIST_TAG, LIST_HANDLER_CLASS);
        digester.addSetProperties(DEF_LIST_TAG);
        digester.addRule(DEF_LIST_TAG, (Rule)new PutAttributeRule(digester));
        digester.addObjectCreate(ADD_LIST_ELE_TAG, PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addRule(ADD_LIST_ELE_TAG, (Rule)new FillAttributeRule(digester));
        digester.addSetNext(ADD_LIST_ELE_TAG, "add", PUT_ATTRIBUTE_HANDLER_CLASS);
        digester.addObjectCreate(NESTED_LIST, LIST_HANDLER_CLASS);
        digester.addSetProperties(NESTED_LIST);
        digester.addSetNext(NESTED_LIST, "add", PUT_ATTRIBUTE_HANDLER_CLASS);
    }

    public void addDefinition(Definition definition) {
        String name = definition.getName();
        if (name == null) {
            throw new DigesterDefinitionsReaderException("A root definition has been defined with no name");
        }
        this.definitions.put(name, definition);
    }

    protected String[] getRegistrations() {
        if (this.registrations == null) {
            this.registrations = new String[]{"-//Apache Software Foundation//DTD Tiles Configuration 3.0//EN", "/org/apache/tiles/resources/tiles-config_3_0.dtd"};
        }
        return this.registrations;
    }
}

