/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.struts2.StrutsException;
import org.apache.struts2.components.UIBean;
import org.apache.struts2.dispatcher.PrepareOperations;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.ognl.ThreadAllowlist;
import org.apache.struts2.util.CompoundRoot;
import org.apache.struts2.util.ValueStack;
import org.apache.struts2.util.reflection.ReflectionProvider;
import org.apache.struts2.views.annotations.StrutsTag;

@StrutsTag(name="debug", tldTagClass="org.apache.struts2.views.jsp.ui.DebugTag", description="Prints debugging information (Only if 'struts.devMode' is enabled)")
public class Debug
extends UIBean {
    public static final String TEMPLATE = "debug";
    protected ReflectionProvider reflectionProvider;
    private ThreadAllowlist threadAllowlist;

    public Debug(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    @Inject
    public void setReflectionProvider(ReflectionProvider prov) {
        this.reflectionProvider = prov;
    }

    @Inject
    public void setThreadAllowlist(ThreadAllowlist threadAllowlist) {
        this.threadAllowlist = threadAllowlist;
    }

    @Override
    protected String getDefaultTemplate() {
        return TEMPLATE;
    }

    @Override
    public boolean start(Writer writer) {
        boolean result = super.start(writer);
        if (this.showDebug()) {
            ValueStack stack = this.getStack();
            this.allowList(stack.getRoot());
            Iterator iter = stack.getRoot().iterator();
            ArrayList<DebugMapEntry> stackValues = new ArrayList<DebugMapEntry>(stack.getRoot().size());
            while (iter.hasNext()) {
                Map<String, Object> values;
                Object o = iter.next();
                try {
                    values = this.reflectionProvider.getBeanMap(o);
                }
                catch (Exception e) {
                    throw new StrutsException("Caught an exception while getting the property values of " + String.valueOf(o), e);
                }
                this.allowListClass(o);
                stackValues.add(new DebugMapEntry(o.getClass().getName(), values));
            }
            this.addParameter("stackValues", stackValues);
        }
        return result;
    }

    private void allowList(CompoundRoot root) {
        root.forEach(this::allowListClass);
    }

    private void allowListClass(Object o) {
        this.threadAllowlist.allowClassHierarchy(o.getClass());
    }

    @Override
    public boolean end(Writer writer, String body) {
        if (this.showDebug()) {
            return super.end(writer, body);
        }
        this.popComponentStack();
        return false;
    }

    protected boolean showDebug() {
        return this.devMode || Boolean.TRUE == PrepareOperations.getDevModeOverride();
    }

    private static class DebugMapEntry
    implements Map.Entry<String, Object> {
        private final String key;
        private Object value;

        DebugMapEntry(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object newVal) {
            Object oldVal = this.value;
            this.value = newVal;
            return oldVal;
        }
    }
}

