/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import net.sf.jasperreports.engine.JRBiConsumer;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRResourcesFillUtil;
import net.sf.jasperreports.engine.util.LocalJasperReportsContext;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.SimpleRepositoryContext;

public class DatasetExecution {
    private JasperReport report;
    private Map<String, Object> parameterValues;
    private JRFillDataset fillDataset;

    public DatasetExecution(RepositoryContext repositoryContext, JasperReport report, Map<String, Object> parameters) {
        this.report = report;
        this.parameterValues = parameters == null ? new HashMap<String, Object>() : new HashMap<String, Object>(parameters);
        this.parameterValues.put("JASPER_REPORT", report);
        ObjectFactory factory = new ObjectFactory();
        JRDataset reportDataset = report.getMainDataset();
        this.fillDataset = factory.getDataset(reportDataset);
        JasperReportsContext depContext = LocalJasperReportsContext.getLocalContext(repositoryContext.getJasperReportsContext(), parameters);
        RepositoryContext fillRepositoryContext = depContext == repositoryContext.getJasperReportsContext() ? repositoryContext : SimpleRepositoryContext.of(depContext, repositoryContext.getResourceContext());
        this.fillDataset.setRepositoryContext(fillRepositoryContext);
    }

    public void evaluateParameters(BiConsumer<JRParameter, Object> parameterConsumer) throws JRException {
        try {
            this.runWithParameters(() -> {
                JRParameter[] parameters = this.fillDataset.getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    JRParameter param = parameters[i];
                    Object value = this.fillDataset.getParameterValue(param.getName());
                    parameterConsumer.accept(param, value);
                }
                return null;
            });
        }
        catch (JRException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JRRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R> R runWithParameters(Callable<R> action) throws Exception {
        this.fillDataset.createCalculator(this.report);
        this.fillDataset.initCalculator();
        JRResourcesFillUtil.ResourcesFillContext resourcesContext = JRResourcesFillUtil.setResourcesFillContext(this.parameterValues);
        try {
            this.fillDataset.setParameterValues(this.parameterValues);
            R r = action.call();
            return r;
        }
        finally {
            this.fillDataset.disposeParameterContributors();
            JRResourcesFillUtil.revertResourcesFillContext(resourcesContext);
        }
    }

    public void evaluateDataSource(JRBiConsumer<JRDataSource, Map<String, Object>> dataSourceConsumer) throws Exception {
        this.runWithParameters(() -> {
            try {
                this.fillDataset.evaluateFieldProperties();
                this.fillDataset.initDatasource();
                dataSourceConsumer.accept(this.fillDataset.dataSource, this.parameterValues);
                Object var2_2 = null;
                return var2_2;
            }
            finally {
                this.fillDataset.closeDatasource();
            }
        });
    }

    protected static class ObjectFactory
    extends JRFillObjectFactory {
        protected ObjectFactory() {
            super((JRBaseFiller)null, null);
        }

        @Override
        public JRFillGroup getGroup(JRGroup group) {
            JRDesignGroup dummyGroup = new JRDesignGroup();
            dummyGroup.setName("DUMMY_GROUP");
            return super.getGroup(dummyGroup);
        }
    }
}

