/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.iconlabel;

import java.io.IOException;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.export.GenericElementHtmlHandler;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterContext;

public class IconLabelElementHtmlHandler
implements GenericElementHtmlHandler {
    private static final IconLabelElementHtmlHandler INSTANCE = new IconLabelElementHtmlHandler();

    public static IconLabelElementHtmlHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public String getHtmlFragment(JRHtmlExporterContext context, JRGenericPrintElement element) {
        JRPrintText labelPrintText = (JRPrintText)element.getParameterValue("labelTextElement");
        if (labelPrintText == null) {
            return null;
        }
        JRBasePrintFrame frame = new JRBasePrintFrame(element.getDefaultStyleProvider());
        frame.setX(element.getX());
        frame.setY(element.getY());
        frame.setWidth(element.getWidth());
        frame.setHeight(element.getHeight());
        frame.setStyle(element.getStyle());
        frame.setBackcolor(element.getBackcolor());
        frame.setForecolor(element.getForecolor());
        frame.setMode(element.getMode());
        JRLineBox lineBox = (JRLineBox)element.getParameterValue("lineBox");
        if (lineBox != null) {
            frame.copyBox(lineBox);
        }
        frame.addElement(labelPrintText);
        JRPrintText iconPrintText = (JRPrintText)element.getParameterValue("iconTextElement");
        if (iconPrintText != null) {
            frame.addElement(iconPrintText);
        }
        HtmlExporter htmlExporter = (HtmlExporter)context.getExporterRef();
        ArrayList<JRPrintElement> elements = new ArrayList<JRPrintElement>();
        elements.add(frame);
        try {
            htmlExporter.exportElements(elements);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        return "";
    }

    @Override
    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }
}

