/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRClassLoader;

public class JsonLoader {
    private static final Class jacksonUtilClass;
    private static final Method jacksonUtilGetInstanceMethod;
    private final JasperReportsContext jasperReportsContext;
    private final Object jacksonUtilObject;
    private Method loadObjectMethod;
    private Method loadListMethod;

    protected JsonLoader(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
        if (jacksonUtilGetInstanceMethod == null) {
            this.jacksonUtilObject = null;
        } else {
            try {
                this.jacksonUtilObject = jacksonUtilGetInstanceMethod.invoke(null, jasperReportsContext);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new JRRuntimeException(e);
            }
        }
    }

    public static JsonLoader getInstance(JasperReportsContext jasperReportsContext) {
        return new JsonLoader(jasperReportsContext);
    }

    public <T> T loadObject(String jsonData, Class<T> clazz) {
        Object result = null;
        if (this.jacksonUtilObject != null && jsonData != null) {
            try {
                if (this.loadObjectMethod == null) {
                    this.loadObjectMethod = jacksonUtilClass.getMethod("loadObject", String.class, Class.class);
                }
                result = this.loadObjectMethod.invoke(this.jacksonUtilObject, jsonData, clazz);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new JRRuntimeException(e);
            }
        }
        return (T)result;
    }

    public <T> T loadObject(String jsonData, String className) {
        Object result = null;
        if (this.jacksonUtilObject != null && jsonData != null) {
            Class<?> clazz = null;
            try {
                clazz = JRClassLoader.loadClassForRealName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz != null) {
                try {
                    if (this.loadObjectMethod == null) {
                        this.loadObjectMethod = jacksonUtilClass.getMethod("loadObject", String.class, Class.class);
                    }
                    result = this.loadObjectMethod.invoke(this.jacksonUtilObject, jsonData, clazz);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new JRRuntimeException(e);
                }
            }
        }
        return (T)result;
    }

    public <T> List<T> loadList(String jsonData, Class<T> clazz) {
        List result = null;
        if (this.jacksonUtilObject != null && jsonData != null) {
            try {
                if (this.loadListMethod == null) {
                    this.loadListMethod = jacksonUtilClass.getMethod("loadList", String.class, Class.class);
                }
                result = (List)this.loadListMethod.invoke(this.jacksonUtilObject, jsonData, clazz);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new JRRuntimeException(e);
            }
        }
        return result;
    }

    static {
        Class<?> localJacksonUtilClass = null;
        Method localGetInstanceMethod = null;
        try {
            localJacksonUtilClass = JRClassLoader.loadClassForRealName("net.sf.jasperreports.jackson.util.JacksonUtil");
            localGetInstanceMethod = localJacksonUtilClass.getDeclaredMethod("getInstance", JasperReportsContext.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        jacksonUtilClass = localJacksonUtilClass;
        jacksonUtilGetInstanceMethod = localGetInstanceMethod;
    }
}

