/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.convention;

import org.apache.commons.lang3.BooleanUtils;
import org.apache.struts2.config.Configuration;
import org.apache.struts2.config.ConfigurationException;
import org.apache.struts2.config.ConfigurationProvider;
import org.apache.struts2.config.ContainerProvider;
import org.apache.struts2.convention.ActionConfigBuilder;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.DispatcherListener;
import org.apache.struts2.inject.Container;
import org.apache.struts2.inject.ContainerBuilder;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.util.location.LocatableProperties;

public class ClasspathConfigurationProvider
implements ConfigurationProvider,
DispatcherListener {
    private final ActionConfigBuilder actionConfigBuilder;
    private boolean devMode;
    private boolean reload;
    private boolean listeningToDispatcher;

    @Inject
    public ClasspathConfigurationProvider(Container container) {
        this.actionConfigBuilder = (ActionConfigBuilder)container.getInstance(ActionConfigBuilder.class, (String)container.getInstance(String.class, "struts.convention.actionConfigBuilder"));
    }

    @Inject(value="struts.devMode")
    public void setDevMode(String mode) {
        this.devMode = BooleanUtils.toBoolean((String)mode);
    }

    @Inject(value="struts.convention.classes.reload")
    public void setReload(String reload) {
        this.reload = BooleanUtils.toBoolean((String)reload);
    }

    public void destroy() {
        if (this.listeningToDispatcher) {
            Dispatcher.removeDispatcherListener((DispatcherListener)this);
        }
        this.actionConfigBuilder.destroy();
    }

    public void init(Configuration configuration) {
        if (this.devMode && this.reload && !this.listeningToDispatcher) {
            this.listeningToDispatcher = true;
            Dispatcher.addDispatcherListener((DispatcherListener)this);
        }
    }

    public void register(ContainerBuilder containerBuilder, LocatableProperties locatableProperties) throws ConfigurationException {
    }

    public void loadPackages() throws ConfigurationException {
    }

    public boolean needsReload() {
        return this.devMode && this.reload && this.actionConfigBuilder.needsReload();
    }

    public void dispatcherInitialized(Dispatcher du) {
        du.getConfigurationManager().addContainerProvider((ContainerProvider)this);
    }

    public void dispatcherDestroyed(Dispatcher du) {
    }
}

