/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.columns.ACompressedArray;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.HashMapToInt;
import org.apache.sysds.runtime.frame.data.columns.RaggedArray;
import org.apache.sysds.runtime.frame.data.compress.ArrayCompressionStatistics;
import org.apache.sysds.runtime.matrix.data.Pair;

public class DDCArray<T>
extends ACompressedArray<T> {
    private final Array<T> dict;
    private final AMapToData map;

    public DDCArray(Array<T> dict, AMapToData map) {
        super(map.size());
        this.dict = dict;
        this.map = map;
        if (FrameBlock.debug && dict != null && dict.size() != map.getUnique()) {
            LOG.warn((Object)("Invalid DDCArray, dictionary size (" + dict.size() + ") is not equal to map unique (" + map.getUnique() + ")"));
        }
    }

    public Array<T> getDict() {
        return this.dict;
    }

    public AMapToData getMap() {
        return this.map;
    }

    public <J> DDCArray<J> setDict(Array<J> dict) {
        return new DDCArray<J>(dict, this.map);
    }

    public DDCArray<T> setMap(AMapToData map) {
        return new DDCArray<T>(this.dict, map);
    }

    public DDCArray<T> nullDict() {
        return new DDCArray<T>(null, this.map);
    }

    private static int getTryThreshold(Types.ValueType t, int allRows, long inMemSize) {
        switch (t) {
            case BOOLEAN: {
                return 1;
            }
            case UINT4: 
            case UINT8: {
                return 2;
            }
            case CHARACTER: {
                return 256;
            }
            case FP32: 
            case INT32: 
            case HASH32: {
                return 65536;
            }
        }
        int i = 256;
        long mapSize = MapToFactory.estimateInMemorySize(allRows, i);
        long dictSize = ArrayFactory.getInMemorySize(t, allRows / i, false);
        while (allRows >= i && inMemSize > dictSize + mapSize) {
            mapSize = MapToFactory.estimateInMemorySize(allRows, i *= 2);
            dictSize = ArrayFactory.getInMemorySize(t, i, false);
        }
        return Math.min(allRows, i);
    }

    public static <T> Array<T> compressToDDC(Array<T> arr) {
        return DDCArray.compressToDDC(arr, Integer.MAX_VALUE);
    }

    public static <T> Array<T> compressToDDC(Array<T> arr, int estimateUnique) {
        try {
            int s = arr.size();
            if (s <= 10 || arr instanceof RaggedArray) {
                return arr;
            }
            int t = DDCArray.getTryThreshold(arr.getValueType(), s, arr.getInMemorySize());
            HashMapToInt rcd = new HashMapToInt(estimateUnique == Integer.MAX_VALUE ? 16 : estimateUnique);
            AMapToData m = MapToFactory.create(s, Math.min(t, estimateUnique));
            int id = 0;
            for (int i = 0; i < s && id < t; ++i) {
                id = arr.setAndAddToDict(rcd, m, i, id);
            }
            if (rcd.size() >= t || rcd.size() > s / 2) {
                return arr;
            }
            AMapToData md = m.resize(rcd.size());
            Array ar = rcd.inverse(arr.getValueType());
            return new DDCArray(ar, md);
        }
        catch (Exception e) {
            String arrS = arr.toString();
            arrS = arrS.substring(0, Math.min(10000, arrS.length()));
            throw new DMLCompressionException("Failed to compress:\n" + arrS, e);
        }
    }

    @Override
    protected HashMapToInt<T> createRecodeMap(int estimate, ExecutorService pool, int k) throws InterruptedException, ExecutionException {
        return this.dict.createRecodeMap(estimate, pool, k);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(ArrayFactory.FrameArrayType.DDC.ordinal());
        this.map.write(out);
        if (this.dict == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.dict.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        throw new DMLRuntimeException("Should not be called");
    }

    public static DDCArray<?> read(DataInput in) throws IOException {
        AMapToData map = MapToFactory.readIn(in);
        if (in.readBoolean()) {
            return new DDCArray(ArrayFactory.read(in, map.getUnique()), map);
        }
        return new DDCArray(null, map);
    }

    @Override
    public T get(int index) {
        return this.dict.get(this.map.getIndex(index));
    }

    @Override
    public T getInternal(int index) {
        return this.dict.getInternal(this.map.getIndex(index));
    }

    @Override
    public double[] extractDouble(double[] ret, int rl, int ru) {
        for (int i = rl; i < ru; ++i) {
            ret[i - rl] = this.getAsDouble(i);
        }
        return ret;
    }

    @Override
    public double getAsDouble(int i) {
        return this.dict.getAsDouble(this.map.getIndex(i));
    }

    @Override
    public double getAsNaNDouble(int i) {
        return this.dict.getAsNaNDouble(this.map.getIndex(i));
    }

    @Override
    public Array<T> append(Array<T> other) {
        throw new DMLCompressionException("Currently not supported to append compressed but could be cool");
    }

    @Override
    public Array<T> slice(int rl, int ru) {
        return new DDCArray<T>(this.dict, this.map.slice(rl, ru));
    }

    @Override
    public byte[] getAsByteArray() {
        throw new DMLCompressionException("Unimplemented method 'getAsByteArray'");
    }

    @Override
    public Types.ValueType getValueType() {
        return this.dict == null ? Types.ValueType.STRING : this.dict.getValueType();
    }

    @Override
    public Pair<Types.ValueType, Boolean> analyzeValueType(int maxCells) {
        return this.dict.analyzeValueType(maxCells);
    }

    @Override
    public void set(int rl, int ru, Array<T> value, int rlSrc) {
        if (!(value instanceof DDCArray)) {
            throw new DMLCompressionException("Invalid to set value in CompressedArray");
        }
        DDCArray dc = (DDCArray)value;
        this.checkCompressedSet(dc);
        this.map.set(rl, ru + 1, rlSrc, dc.map);
    }

    private void checkCompressedSet(DDCArray<T> dc) {
        if (this.dict != null && dc.dict != null && (dc.dict.size() != this.dict.size() || FrameBlock.debug && !dc.dict.equals(this.dict)) || this.map.getUnique() < dc.map.getUnique()) {
            throw new DMLCompressionException("Invalid setting of DDC Array, of incompatible instance.\ndict1 is null: " + (this.dict == null) + "\ndict2 is null: " + (dc.dict == null) + "\nmap1 unique: " + this.map.getUnique() + "\nmap2 unique: " + dc.map.getUnique());
        }
    }

    @Override
    public ArrayFactory.FrameArrayType getFrameArrayType() {
        return ArrayFactory.FrameArrayType.DDC;
    }

    @Override
    public long getExactSerializedSize() {
        return 2L + this.map.getExactSizeOnDisk() + this.dict.getExactSerializedSize();
    }

    @Override
    public Array<?> changeType(Types.ValueType t) {
        return new DDCArray(this.dict.changeType(t), this.map);
    }

    @Override
    public Array<?> changeTypeWithNulls(Types.ValueType t) {
        Array<?> d2 = this.dict.changeTypeWithNulls(t);
        return new DDCArray(d2, this.map);
    }

    @Override
    public boolean isShallowSerialize() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Array<T> select(int[] indices) {
        int[] newSelect = new int[indices.length];
        for (int i = 0; i < newSelect.length; ++i) {
            newSelect[i] = this.map.getIndex(indices[i]);
        }
        return this.dict.select(newSelect);
    }

    @Override
    public Array<T> select(boolean[] select, int nTrue) {
        AMapToData map2 = MapToFactory.create(nTrue, this.map.getUnique());
        int j = 0;
        for (int i = 0; i < select.length; ++i) {
            if (!select[i]) continue;
            map2.set(j++, this.map.getIndex(i));
        }
        return new DDCArray<T>(this.dict, map2);
    }

    @Override
    public boolean isNotEmpty(int i) {
        return this.dict.isNotEmpty(this.map.getIndex(i));
    }

    @Override
    public Array<T> clone() {
        return new DDCArray<T>(this.dict, this.map);
    }

    @Override
    public double hashDouble(int idx) {
        return this.dict.hashDouble(this.map.getIndex(idx));
    }

    @Override
    public long getInMemorySize() {
        return super.getInMemorySize() + (this.dict == null ? 8L : this.dict.getInMemorySize()) + this.map.getInMemorySize();
    }

    public static long estimateInMemorySize(int memSizeBitPerElement, int estDistinct, int nRow) {
        return (long)estDistinct * (long)memSizeBitPerElement + MapToFactory.estimateInMemorySize(nRow, estDistinct);
    }

    @Override
    public boolean containsNull() {
        return this.dict.containsNull();
    }

    @Override
    public boolean equals(Array<T> other) {
        if (other instanceof DDCArray) {
            DDCArray ot = (DDCArray)other;
            return this.dict.equals(ot.dict) && this.map.equals(ot.map);
        }
        return false;
    }

    @Override
    public boolean possiblyContainsNaN() {
        return this.dict.possiblyContainsNaN();
    }

    @Override
    public double[] minMax() {
        return this.minMax(0, this.dict.size());
    }

    @Override
    public double[] minMax(int l, int u) {
        if (u <= this.dict.size()) {
            return this.dict.minMax(l, u);
        }
        if (l > this.dict.size()) {
            return new double[]{Double.MIN_VALUE, Double.MAX_VALUE};
        }
        return this.dict.minMax(l, this.dict.size());
    }

    @Override
    public ArrayCompressionStatistics statistics(int nSamples) {
        long memSize = this.getInMemorySize();
        int memSizePerElement = this.estMemSizePerElement(this.getValueType(), memSize);
        return new ArrayCompressionStatistics(memSizePerElement, this.dict.size(), false, this.getValueType(), false, ArrayFactory.FrameArrayType.DDC, this.getInMemorySize(), this.getInMemorySize(), true);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n%15s", "Values: "));
        sb.append(this.dict);
        sb.append(String.format("\n%15s", "Data: "));
        sb.append(this.map);
        return sb.toString();
    }
}

