/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.traffic;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.traffic.AbstractTrafficShapingHandler;
import org.jboss.netty.handler.traffic.GlobalChannelTrafficCounter;
import org.jboss.netty.handler.traffic.TrafficCounter;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.ObjectSizeEstimator;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ChannelHandler.Sharable
public class GlobalChannelTrafficShapingHandler
extends AbstractTrafficShapingHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(GlobalChannelTrafficShapingHandler.class);
    final ConcurrentMap<Integer, PerChannel> channelQueues = new ConcurrentHashMap<Integer, PerChannel>();
    private final AtomicLong queuesSize = new AtomicLong();
    private final AtomicLong cumulativeWrittenBytes = new AtomicLong();
    private final AtomicLong cumulativeReadBytes = new AtomicLong();
    long maxGlobalWriteSize = 0x19000000L;
    private volatile long writeChannelLimit;
    private volatile long readChannelLimit;
    private static final float DEFAULT_DEVIATION = 0.1f;
    private static final float MAX_DEVIATION = 0.4f;
    private static final float DEFAULT_SLOWDOWN = 0.4f;
    private static final float DEFAULT_ACCELERATION = -0.1f;
    private volatile float maxDeviation;
    private volatile float accelerationFactor;
    private volatile float slowDownFactor;
    private volatile boolean readDeviationActive;
    private volatile boolean writeDeviationActive;

    void createGlobalTrafficCounter(Timer timer) {
        this.setMaxDeviation(0.1f, 0.4f, -0.1f);
        if (timer == null) {
            throw new IllegalArgumentException("Timer must not be null");
        }
        GlobalChannelTrafficCounter tc = new GlobalChannelTrafficCounter(this, timer, "GlobalChannelTC", this.checkInterval);
        this.setTrafficCounter(tc);
        ((TrafficCounter)tc).start();
    }

    @Override
    int userDefinedWritabilityIndex() {
        return 3;
    }

    public GlobalChannelTrafficShapingHandler(Timer timer, long writeGlobalLimit, long readGlobalLimit, long writeChannelLimit, long readChannelLimit, long checkInterval, long maxTime) {
        super(timer, writeGlobalLimit, readGlobalLimit, checkInterval, maxTime);
        this.createGlobalTrafficCounter(timer);
        this.writeChannelLimit = writeChannelLimit;
        this.readChannelLimit = readChannelLimit;
    }

    public GlobalChannelTrafficShapingHandler(Timer timer, long writeGlobalLimit, long readGlobalLimit, long writeChannelLimit, long readChannelLimit, long checkInterval) {
        super(timer, writeGlobalLimit, readGlobalLimit, checkInterval);
        this.writeChannelLimit = writeChannelLimit;
        this.readChannelLimit = readChannelLimit;
        this.createGlobalTrafficCounter(timer);
    }

    public GlobalChannelTrafficShapingHandler(Timer timer, long writeGlobalLimit, long readGlobalLimit, long writeChannelLimit, long readChannelLimit) {
        super(timer, writeGlobalLimit, readGlobalLimit);
        this.writeChannelLimit = writeChannelLimit;
        this.readChannelLimit = readChannelLimit;
        this.createGlobalTrafficCounter(timer);
    }

    public GlobalChannelTrafficShapingHandler(Timer timer, long checkInterval) {
        super(timer, checkInterval);
        this.createGlobalTrafficCounter(timer);
    }

    public GlobalChannelTrafficShapingHandler(Timer timer) {
        super(timer);
        this.createGlobalTrafficCounter(timer);
    }

    public GlobalChannelTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit, long writeChannelLimit, long readChannelLimit, long checkInterval, long maxTime) {
        super(objectSizeEstimator, timer, writeLimit, readLimit, checkInterval, maxTime);
        this.writeChannelLimit = writeChannelLimit;
        this.readChannelLimit = readChannelLimit;
        this.createGlobalTrafficCounter(timer);
    }

    public GlobalChannelTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit, long writeChannelLimit, long readChannelLimit, long checkInterval) {
        super(objectSizeEstimator, timer, writeLimit, readLimit, checkInterval);
        this.writeChannelLimit = writeChannelLimit;
        this.readChannelLimit = readChannelLimit;
        this.createGlobalTrafficCounter(timer);
    }

    public GlobalChannelTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit, long writeChannelLimit, long readChannelLimit) {
        super(objectSizeEstimator, timer, writeLimit, readLimit);
        this.writeChannelLimit = writeChannelLimit;
        this.readChannelLimit = readChannelLimit;
        this.createGlobalTrafficCounter(timer);
    }

    public GlobalChannelTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long checkInterval) {
        super(objectSizeEstimator, timer, checkInterval);
        this.createGlobalTrafficCounter(timer);
    }

    public GlobalChannelTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer) {
        super(objectSizeEstimator, timer);
        this.createGlobalTrafficCounter(timer);
    }

    public float maxDeviation() {
        return this.maxDeviation;
    }

    public float accelerationFactor() {
        return this.accelerationFactor;
    }

    public float slowDownFactor() {
        return this.slowDownFactor;
    }

    public void setMaxDeviation(float maxDeviation, float slowDownFactor, float accelerationFactor) {
        if (maxDeviation > 0.4f) {
            throw new IllegalArgumentException("maxDeviation must be <= 0.4");
        }
        if (slowDownFactor < 0.0f) {
            throw new IllegalArgumentException("slowDownFactor must be >= 0");
        }
        if (accelerationFactor > 0.0f) {
            throw new IllegalArgumentException("accelerationFactor must be <= 0");
        }
        this.maxDeviation = maxDeviation;
        this.accelerationFactor = 1.0f + accelerationFactor;
        this.slowDownFactor = 1.0f + slowDownFactor;
    }

    private void computeDeviationCumulativeBytes() {
        long maxWrittenBytes = 0L;
        long maxReadBytes = 0L;
        long minWrittenBytes = Long.MAX_VALUE;
        long minReadBytes = Long.MAX_VALUE;
        for (PerChannel perChannel : this.channelQueues.values()) {
            long value = perChannel.channelTrafficCounter.getCumulativeWrittenBytes();
            if (maxWrittenBytes < value) {
                maxWrittenBytes = value;
            }
            if (minWrittenBytes > value) {
                minWrittenBytes = value;
            }
            if (maxReadBytes < (value = perChannel.channelTrafficCounter.getCumulativeReadBytes())) {
                maxReadBytes = value;
            }
            if (minReadBytes <= value) continue;
            minReadBytes = value;
        }
        boolean multiple = this.channelQueues.size() > 1;
        this.readDeviationActive = multiple && minReadBytes < maxReadBytes / 2L;
        this.writeDeviationActive = multiple && minWrittenBytes < maxWrittenBytes / 2L;
        this.cumulativeWrittenBytes.set(maxWrittenBytes);
        this.cumulativeReadBytes.set(maxReadBytes);
    }

    @Override
    protected void doAccounting(TrafficCounter counter) {
        this.computeDeviationCumulativeBytes();
        super.doAccounting(counter);
    }

    private long computeBalancedWait(float maxLocal, float maxGlobal, long wait) {
        if (maxGlobal == 0.0f) {
            return wait;
        }
        float ratio = maxLocal / maxGlobal;
        if (ratio > this.maxDeviation) {
            if (ratio < 1.0f - this.maxDeviation) {
                return wait;
            }
            ratio = this.slowDownFactor;
            if (wait < 10L) {
                wait = 10L;
            }
        } else {
            ratio = this.accelerationFactor;
        }
        return (long)((float)wait * ratio);
    }

    public long getMaxGlobalWriteSize() {
        return this.maxGlobalWriteSize;
    }

    public void setMaxGlobalWriteSize(long maxGlobalWriteSize) {
        this.maxGlobalWriteSize = maxGlobalWriteSize;
    }

    public long queuesSize() {
        return this.queuesSize.get();
    }

    public void configureChannel(long newWriteLimit, long newReadLimit) {
        this.writeChannelLimit = newWriteLimit;
        this.readChannelLimit = newReadLimit;
        long now = TrafficCounter.milliSecondFromNano();
        for (PerChannel perChannel : this.channelQueues.values()) {
            perChannel.channelTrafficCounter.resetAccounting(now);
        }
    }

    public long getWriteChannelLimit() {
        return this.writeChannelLimit;
    }

    public void setWriteChannelLimit(long writeLimit) {
        this.writeChannelLimit = writeLimit;
        long now = TrafficCounter.milliSecondFromNano();
        for (PerChannel perChannel : this.channelQueues.values()) {
            perChannel.channelTrafficCounter.resetAccounting(now);
        }
    }

    public long getReadChannelLimit() {
        return this.readChannelLimit;
    }

    public void setReadChannelLimit(long readLimit) {
        this.readChannelLimit = readLimit;
        long now = TrafficCounter.milliSecondFromNano();
        for (PerChannel perChannel : this.channelQueues.values()) {
            perChannel.channelTrafficCounter.resetAccounting(now);
        }
    }

    public final void release() {
        this.trafficCounter.stop();
    }

    private PerChannel getOrSetPerChannel(ChannelHandlerContext ctx) {
        Channel channel = ctx.getChannel();
        Integer key = channel.hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(key);
        if (perChannel == null) {
            perChannel = new PerChannel();
            perChannel.messagesQueue = new LinkedList<ToSend>();
            perChannel.channelTrafficCounter = new TrafficCounter(this, null, "ChannelTC" + ctx.getChannel().hashCode(), this.checkInterval);
            perChannel.queueSize = 0L;
            perChannel.lastWriteTimestamp = perChannel.lastReadTimestamp = TrafficCounter.milliSecondFromNano();
            this.channelQueues.put(key, perChannel);
        }
        return perChannel;
    }

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.getOrSetPerChannel(ctx);
        this.trafficCounter.resetCumulativeTime();
        super.channelConnected(ctx, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.trafficCounter.resetCumulativeTime();
        Channel channel = ctx.getChannel();
        Integer key = channel.hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.remove(key);
        if (perChannel != null) {
            PerChannel perChannel2 = perChannel;
            synchronized (perChannel2) {
                this.queuesSize.addAndGet(-perChannel.queueSize);
                perChannel.messagesQueue.clear();
            }
        }
        this.releaseWriteSuspended(ctx);
        this.releaseReadSuspended(ctx);
        super.channelClosed(ctx, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        long now;
        block13: {
            block14: {
                now = TrafficCounter.milliSecondFromNano();
                try {
                    AbstractTrafficShapingHandler.ReadWriteStatus rws = GlobalChannelTrafficShapingHandler.checkAttachment(ctx);
                    long size = this.calculateSize(evt.getMessage());
                    if (size <= 0L) break block13;
                    long waitGlobal = this.trafficCounter.readTimeToWait(size, this.getReadLimit(), this.maxTime, now);
                    Integer key = ctx.getChannel().hashCode();
                    PerChannel perChannel = (PerChannel)this.channelQueues.get(key);
                    long wait = 0L;
                    if (perChannel != null) {
                        wait = perChannel.channelTrafficCounter.readTimeToWait(size, this.readChannelLimit, this.maxTime, now);
                        if (this.readDeviationActive) {
                            long maxLocalRead = perChannel.channelTrafficCounter.getCumulativeReadBytes();
                            long maxGlobalRead = this.cumulativeReadBytes.get();
                            if (maxLocalRead <= 0L) {
                                maxLocalRead = 0L;
                            }
                            if (maxGlobalRead < maxLocalRead) {
                                maxGlobalRead = maxLocalRead;
                            }
                            wait = this.computeBalancedWait(maxLocalRead, maxGlobalRead, wait);
                        }
                    }
                    if (wait < waitGlobal) {
                        wait = waitGlobal;
                    }
                    if ((wait = this.checkWaitReadTime(ctx, wait, now)) < 10L) break block13;
                    if (this.release.get()) {
                        Object var19_13 = null;
                        this.informReadOperation(ctx, now);
                        ctx.sendUpstream(evt);
                        return;
                    }
                    Channel channel = ctx.getChannel();
                    if (channel == null || !channel.isConnected()) break block13;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Read suspend: " + wait + ':' + channel.isReadable() + ':' + rws.readSuspend);
                    }
                    if (this.timer == null) {
                        Thread.sleep(wait);
                        break block14;
                    }
                    if (channel.isReadable() && !rws.readSuspend) {
                        rws.readSuspend = true;
                        channel.setReadable(false);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Suspend final status => " + channel.isReadable() + ':' + rws.readSuspend);
                        }
                        if (rws.reopenReadTimerTask == null) {
                            rws.reopenReadTimerTask = new AbstractTrafficShapingHandler.ReopenReadTimerTask(ctx);
                        }
                        this.timeout = this.timer.newTimeout(rws.reopenReadTimerTask, wait, TimeUnit.MILLISECONDS);
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var19_16 = null;
                    this.informReadOperation(ctx, now);
                    ctx.sendUpstream(evt);
                    throw throwable;
                }
            }
            Object var19_14 = null;
            this.informReadOperation(ctx, now);
            ctx.sendUpstream(evt);
            return;
        }
        Object var19_15 = null;
        this.informReadOperation(ctx, now);
        ctx.sendUpstream(evt);
    }

    @Override
    protected long checkWaitReadTime(ChannelHandlerContext ctx, long wait, long now) {
        Integer key = ctx.getChannel().hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(key);
        if (perChannel != null && wait > this.maxTime && now + wait - perChannel.lastReadTimestamp > this.maxTime) {
            wait = this.maxTime;
        }
        return wait;
    }

    @Override
    protected void informReadOperation(ChannelHandlerContext ctx, long now) {
        Integer key = ctx.getChannel().hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(key);
        if (perChannel != null) {
            perChannel.lastReadTimestamp = now;
        }
    }

    protected long maximumCumulativeWrittenBytes() {
        return this.cumulativeWrittenBytes.get();
    }

    protected long maximumCumulativeReadBytes() {
        return this.cumulativeReadBytes.get();
    }

    public Collection<TrafficCounter> channelTrafficCounters() {
        return new AbstractCollection<TrafficCounter>(){

            @Override
            public Iterator<TrafficCounter> iterator() {
                return new Iterator<TrafficCounter>(){
                    final Iterator<PerChannel> iter;
                    {
                        this.iter = GlobalChannelTrafficShapingHandler.this.channelQueues.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public TrafficCounter next() {
                        return this.iter.next().channelTrafficCounter;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return GlobalChannelTrafficShapingHandler.this.channelQueues.size();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRequested(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        long wait = 0L;
        long size = this.calculateSize(evt.getMessage());
        long now = TrafficCounter.milliSecondFromNano();
        try {
            if (size > 0L) {
                long waitGlobal = this.trafficCounter.writeTimeToWait(size, this.getWriteLimit(), this.maxTime, now);
                Integer key = ctx.getChannel().hashCode();
                PerChannel perChannel = (PerChannel)this.channelQueues.get(key);
                if (perChannel != null) {
                    wait = perChannel.channelTrafficCounter.writeTimeToWait(size, this.writeChannelLimit, this.maxTime, now);
                    if (this.writeDeviationActive) {
                        long maxLocalWrite = perChannel.channelTrafficCounter.getCumulativeWrittenBytes();
                        long maxGlobalWrite = this.cumulativeWrittenBytes.get();
                        if (maxLocalWrite <= 0L) {
                            maxLocalWrite = 0L;
                        }
                        if (maxGlobalWrite < maxLocalWrite) {
                            maxGlobalWrite = maxLocalWrite;
                        }
                        wait = this.computeBalancedWait(maxLocalWrite, maxGlobalWrite, wait);
                    }
                }
                if (wait < waitGlobal) {
                    wait = waitGlobal;
                }
                if (wait < 10L || this.release.get()) {
                    wait = 0L;
                }
            }
            Object var18_11 = null;
        }
        catch (Throwable throwable) {
            Object var18_12 = null;
            this.submitWrite(ctx, evt, size, wait, now);
            throw throwable;
        }
        this.submitWrite(ctx, evt, size, wait, now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void submitWrite(final ChannelHandlerContext ctx, MessageEvent evt, long size, long writedelay, long now) throws Exception {
        ToSend newToSend;
        Channel channel = ctx.getChannel();
        Integer key = channel.hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(key);
        if (perChannel == null) {
            perChannel = this.getOrSetPerChannel(ctx);
        }
        long delay = writedelay;
        boolean globalSizeExceeded = false;
        PerChannel perChannel2 = perChannel;
        synchronized (perChannel2) {
            if (writedelay == 0L && perChannel.messagesQueue.isEmpty()) {
                if (!channel.isConnected()) {
                    return;
                }
                this.trafficCounter.bytesRealWriteFlowControl(size);
                perChannel.channelTrafficCounter.bytesRealWriteFlowControl(size);
                ctx.sendDownstream(evt);
                perChannel.lastWriteTimestamp = now;
                return;
            }
            if (delay > this.maxTime && now + delay - perChannel.lastWriteTimestamp > this.maxTime) {
                delay = this.maxTime;
            }
            if (this.timer == null) {
                Thread.sleep(delay);
                if (!ctx.getChannel().isConnected()) {
                    return;
                }
                this.trafficCounter.bytesRealWriteFlowControl(size);
                perChannel.channelTrafficCounter.bytesRealWriteFlowControl(size);
                ctx.sendDownstream(evt);
                perChannel.lastWriteTimestamp = now;
                return;
            }
            if (!ctx.getChannel().isConnected()) {
                return;
            }
            newToSend = new ToSend(delay + now, evt, size);
            perChannel.messagesQueue.add(newToSend);
            perChannel.queueSize += size;
            this.queuesSize.addAndGet(size);
            this.checkWriteSuspend(ctx, delay, perChannel.queueSize);
            if (this.queuesSize.get() > this.maxGlobalWriteSize) {
                globalSizeExceeded = true;
            }
        }
        if (globalSizeExceeded) {
            this.setWritable(ctx, false);
        }
        final long futureNow = newToSend.relativeTimeAction;
        final PerChannel forSchedule = perChannel;
        this.timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                GlobalChannelTrafficShapingHandler.this.sendAllValid(ctx, forSchedule, futureNow);
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAllValid(ChannelHandlerContext ctx, PerChannel perChannel, long now) throws Exception {
        PerChannel perChannel2 = perChannel;
        synchronized (perChannel2) {
            while (!perChannel.messagesQueue.isEmpty()) {
                ToSend newToSend = perChannel.messagesQueue.remove(0);
                if (newToSend.relativeTimeAction <= now) {
                    if (!ctx.getChannel().isConnected()) break;
                    long size = newToSend.size;
                    this.trafficCounter.bytesRealWriteFlowControl(size);
                    perChannel.channelTrafficCounter.bytesRealWriteFlowControl(size);
                    perChannel.queueSize -= size;
                    this.queuesSize.addAndGet(-size);
                    ctx.sendDownstream(newToSend.toSend);
                    perChannel.lastWriteTimestamp = now;
                    continue;
                }
                perChannel.messagesQueue.add(0, newToSend);
                break;
            }
            if (perChannel.messagesQueue.isEmpty()) {
                this.releaseWriteSuspended(ctx);
            }
        }
    }

    @Override
    public String toString() {
        return new StringBuilder(340).append(super.toString()).append(" Write Channel Limit: ").append(this.writeChannelLimit).append(" Read Channel Limit: ").append(this.readChannelLimit).toString();
    }

    private static final class ToSend {
        final long relativeTimeAction;
        final MessageEvent toSend;
        final long size;

        private ToSend(long delay, MessageEvent toSend, long size) {
            this.relativeTimeAction = delay;
            this.toSend = toSend;
            this.size = size;
        }
    }

    static final class PerChannel {
        List<ToSend> messagesQueue;
        TrafficCounter channelTrafficCounter;
        long queueSize;
        long lastWriteTimestamp;
        long lastReadTimestamp;

        PerChannel() {
        }
    }
}

