/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.tez.dag.app.dag.event.DAGEvent;
import org.apache.tez.dag.app.dag.event.DAGEventType;
import org.apache.tez.dag.records.TezDAGID;

public class DAGEventCounterUpdate
extends DAGEvent {
    List<CounterIncrementalUpdate> counterUpdates = new ArrayList<CounterIncrementalUpdate>();

    public DAGEventCounterUpdate(TezDAGID dagId) {
        super(dagId, DAGEventType.DAG_COUNTER_UPDATE);
    }

    public void addCounterUpdate(Enum<?> key, long incrValue) {
        this.counterUpdates.add(new CounterIncrementalUpdate(key, incrValue));
    }

    public List<CounterIncrementalUpdate> getCounterUpdates() {
        return this.counterUpdates;
    }

    public static class CounterIncrementalUpdate {
        Enum<?> key;
        long incrValue;

        public CounterIncrementalUpdate(Enum<?> key, long incrValue) {
            this.key = key;
            this.incrValue = incrValue;
        }

        public Enum<?> getCounterKey() {
            return this.key;
        }

        public long getIncrementValue() {
            return this.incrValue;
        }

        public String toString() {
            return String.format("DAGEventCounterUpdate.CounterIncrementalUpdate(key=%s, incrValue=%d)", this.key, this.incrValue);
        }
    }
}

